/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventSet;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class EventImporter
implements IRunnableWithProgress {
    private final ATDBConnection con;
    private final Amalthea model;

    public EventImporter(ATDBConnection con, Amalthea model) {
        this.con = con;
        this.model = model;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        if (this.model.getEventModel() != null) {
            int eventCount = this.model.getEventModel().getEvents().size();
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Importing events from AMALTHEA...", (int)eventCount);
            try {
                this.con.executeBatchUpdate(atdbCon -> {
                    EList events = this.model.getEventModel().getEvents();
                    for (Event event : events) {
                        if (event instanceof EventSet) continue;
                        String eventName = event.getName();
                        Optional<String> optEventTypeName = EventImporter.getEventTypeName(event);
                        if (optEventTypeName.isPresent()) {
                            atdbCon.insertEventType(optEventTypeName.get());
                        }
                        String eventTypeName = optEventTypeName.orElse("");
                        Optional<String> optEntityName = EventImporter.getEntityName(event);
                        if (optEntityName.isPresent()) {
                            atdbCon.insertEntity(optEntityName.get(), "");
                        }
                        String entityName = optEntityName.orElse("");
                        String sourceEntityName = EventImporter.getSourceEntityName(event).orElse("");
                        atdbCon.insertEvent(eventName, eventTypeName, entityName, sourceEntityName);
                        subMon.worked(1);
                    }
                });
            }
            catch (SQLException e) {
                throw new InvocationTargetException(e);
            }
            subMon.done();
        }
    }

    public static Optional<String> getEventTypeName(Event event) {
        return Stream.of("eventType").map(p -> EventImporter.getPropertyValue((EObject)event, p)).filter(Objects::nonNull).map(p -> p instanceof Enumerator ? ((Enumerator)p).getName() : p.toString()).findFirst();
    }

    public static Optional<String> getEntityName(Event event) {
        return Stream.of("entity").map(p -> EventImporter.getPropertyValue((EObject)event, p)).filter(Objects::nonNull).map(p -> p instanceof INamed ? ((INamed)p).getName() : p.toString()).findFirst();
    }

    public static Optional<String> getSourceEntityName(Event event) {
        return Stream.of("runnable", "process", "core").map(p -> EventImporter.getPropertyValue((EObject)event, p)).filter(Objects::nonNull).map(p -> p instanceof INamed ? ((INamed)p).getName() : p.toString()).findFirst();
    }

    private static Object getPropertyValue(EObject eo, String propertyName) {
        if (eo == null || propertyName == null || eo.eClass() == null) {
            return null;
        }
        EStructuralFeature feature = eo.eClass().getEStructuralFeature(propertyName);
        if (feature == null) {
            return null;
        }
        return eo.eGet(feature);
    }
}

