/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptObjectType;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;

public class ScriptHistoryText
extends StyledText
implements IExecutionListener {
    public static final int STYLE_ERROR = 1;
    public static final int STYLE_RESULT = 3;
    public static final int STYLE_COMMAND = 4;
    private BlendBackgroundJob fBlendBackgroundJob = null;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getParent());
    private final ColorDescriptor fColorDescriptorResult = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(16));
    private final ColorDescriptor fColorDescriptorCommand = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(9));
    private final ColorDescriptor fColorDescriptorError = ColorDescriptor.createFrom((Color)this.getShell().getDisplay().getSystemColor(3));
    private ColorDescriptor fColorDefaultBackground = null;
    private ColorDescriptor fColorShadedBackground = null;
    private IReplEngine fCurrentEngine;

    private static Image getImage(ScriptObjectType type) {
        switch (type) {
            case JAVA_OBJECT: {
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_java_class.png", true);
            }
            case NATIVE_ARRAY: {
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_array.png", true);
            }
            case NATIVE_OBJECT: {
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_object.png", true);
            }
            case VOID: {
                return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/void_type.png", true);
            }
        }
        return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_local_variable.png", true);
    }

    public ScriptHistoryText(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public void addScriptEngine(IReplEngine engine) {
        if (engine != null) {
            engine.addExecutionListener((IExecutionListener)this);
            this.fCurrentEngine = engine;
        }
    }

    public void removeScriptEngine(IReplEngine engine) {
        if (engine != null) {
            engine.removeExecutionListener((IExecutionListener)this);
            Display.getDefault().asyncExec(() -> this.setBackground(this.fResourceManager.createColor(this.fColorDefaultBackground)));
        }
    }

    private ColorDescriptor createShadedBackground(Color defaultColor) {
        int defaultRgb = defaultColor.getRed() + defaultColor.getGreen() + defaultColor.getBlue();
        if (defaultRgb >= 32) {
            return ColorDescriptor.createFrom((RGB)new RGB(Math.max(defaultColor.getRed() - 16, 0), Math.max(defaultColor.getGreen() - 16, 0), Math.max(defaultColor.getBlue() - 16, 0)));
        }
        return ColorDescriptor.createFrom((RGB)new RGB(Math.min(defaultColor.getRed() + 16, 255), Math.min(defaultColor.getGreen() + 16, 255), Math.min(defaultColor.getBlue() + 16, 255)));
    }

    private void initialize() {
        this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        this.fColorDefaultBackground = ColorDescriptor.createFrom((Color)DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
        this.fColorShadedBackground = this.createShadedBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
        JFaceResources.getFontRegistry().addListener(event -> {
            if ("org.eclipse.debug.ui.consoleFont".equals(event.getProperty())) {
                this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            }
        });
        this.setEditable(false);
        this.fBlendBackgroundJob = new BlendBackgroundJob();
        this.addPaintObjectListener(event -> {
            StyleRange style = event.style;
            if (style.data instanceof Image) {
                int lineHeight = event.ascent + event.descent;
                int yOffset = Math.max(0, (lineHeight - ((Image)style.data).getBounds().height) / 2);
                int x = event.x - 5;
                int y = event.y + yOffset + 2;
                event.gc.drawImage((Image)style.data, x, y);
            }
        });
    }

    public void dispose() {
        this.fResourceManager.dispose();
        if (this.fCurrentEngine != null) {
            this.fCurrentEngine.removeExecutionListener((IExecutionListener)this);
            this.fCurrentEngine = null;
        }
        super.dispose();
    }

    public void clear() {
        this.setText("");
        this.setStyleRanges(new StyleRange[0]);
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        try {
            switch (status) {
                case 3: {
                    this.fBlendBackgroundJob.arm();
                    this.printCommand(script.getCode());
                    break;
                }
                case 4: {
                    this.fBlendBackgroundJob.disarm();
                    if (this.fBlendBackgroundJob.fStarted) {
                        Display.getDefault().asyncExec(() -> this.setBackground(this.fResourceManager.createColor(this.fColorDefaultBackground)));
                    }
                    this.printResult(script.getResult());
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printCommand(String message) {
        if (message != null) {
            Display.getDefault().asyncExec(() -> {
                if (!this.isDisposed()) {
                    if (!this.getText().isEmpty()) {
                        this.append("\n");
                    }
                    StyleRange styleRange = this.getStyle(4, this.getText().length(), message.trim().length());
                    this.append(message.trim());
                    this.setStyleRange(styleRange);
                    this.scrollToEnd();
                }
            });
        }
    }

    public void printResult(ScriptResult result) {
        String message = this.getResultMessage(result);
        Image image = this.getResultImage(result);
        Display.getDefault().asyncExec(() -> {
            String out = message.replaceAll("\\r?\\n", "\n\t");
            if (!this.isDisposed()) {
                StyleRange styleRange;
                this.append("\n\t");
                if (image != null) {
                    this.append(" ");
                    styleRange = new StyleRange();
                    styleRange.start = this.getText().length() - 1;
                    styleRange.length = 1;
                    styleRange.data = image;
                    Rectangle rect = image.getBounds();
                    styleRange.metrics = new GlyphMetrics(rect.height, 0, rect.width);
                    this.setStyleRange(styleRange);
                }
                styleRange = this.getStyle(result.hasException() ? 1 : 3, this.getText().length(), out.length());
                this.append(out);
                this.setStyleRange(styleRange);
                this.scrollToEnd();
            }
        });
    }

    private void scrollToEnd() {
        this.setHorizontalPixel(0);
        this.setTopPixel((int)((double)(this.getLineHeight() * this.getLineCount()) * 1.1));
    }

    private String getResultMessage(ScriptResult result) {
        if (result.hasException()) {
            String message = result.getException().getLocalizedMessage();
            return message != null ? message : result.getException().getClass().getName();
        }
        Object executionResult = result.getResult();
        if (this.fCurrentEngine != null) {
            return this.fCurrentEngine.toString(executionResult);
        }
        return executionResult != null ? executionResult.toString() : "null";
    }

    private Image getResultImage(ScriptResult result) {
        if (result.hasException()) {
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/script_exception.png", true);
        }
        if (this.fCurrentEngine != null) {
            ScriptObjectType type = this.fCurrentEngine.getType(result.getResult());
            return ScriptHistoryText.getImage(type);
        }
        return null;
    }

    private StyleRange getStyle(int style, int start, int length) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = length;
        switch (style) {
            case 3: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorResult);
                break;
            }
            case 4: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorCommand);
                styleRange.fontStyle = 1;
                break;
            }
            case 1: {
                styleRange.foreground = this.fResourceManager.createColor(this.fColorDescriptorError);
                styleRange.fontStyle = 2;
                break;
            }
        }
        return styleRange;
    }

    private class BlendBackgroundJob
    extends UIJob {
        private boolean fRun;
        private volatile boolean fStarted;

        public BlendBackgroundJob() {
            super("Darken Script Shell background");
            this.setSystem(true);
        }

        public void arm() {
            this.fRun = true;
            this.fStarted = false;
            this.schedule(300L);
        }

        public void disarm() {
            this.fRun = false;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.fStarted = true;
            if (this.fRun) {
                ScriptHistoryText.this.setBackground(ScriptHistoryText.this.fResourceManager.createColor(ScriptHistoryText.this.fColorShadedBackground));
            }
            return Status.OK_STATUS;
        }
    }
}

