/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.feature.BasePluginListPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class PluginListPage
extends BasePluginListPage {
    private Combo fLaunchConfigsCombo;
    private Button fInitLaunchConfigButton;
    private CheckboxTreeViewer pluginViewer;
    private static final String S_INIT_LAUNCH = "initLaunch";

    public PluginListPage() {
        super("pluginListPage");
        this.setTitle(PDEUIMessages.NewFeatureWizard_PlugPage_title);
        this.setDescription(PDEUIMessages.NewFeatureWizard_PlugPage_desc);
    }

    @Override
    public void createControl(Composite parent) {
        GridData gd;
        boolean initLaunch;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        String[] launchConfigs = this.getLaunchConfigurations();
        IDialogSettings settings = this.getDialogSettings();
        boolean bl = settings != null ? settings.getBoolean(S_INIT_LAUNCH) && launchConfigs.length > 0 : (initLaunch = false);
        if (launchConfigs.length > 0) {
            this.fInitLaunchConfigButton = new Button(container, 16);
            this.fInitLaunchConfigButton.setText(PDEUIMessages.PluginListPage_initializeFromLaunch);
            this.fInitLaunchConfigButton.setSelection(initLaunch);
            this.fInitLaunchConfigButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                boolean initLaunchConfigs = this.fInitLaunchConfigButton.getSelection();
                this.fLaunchConfigsCombo.setEnabled(initLaunchConfigs);
                this.treePart.setEnabled(!initLaunchConfigs);
            }));
            this.fLaunchConfigsCombo = new Combo(container, 8);
            this.fLaunchConfigsCombo.setItems(launchConfigs);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.fLaunchConfigsCombo.setLayoutData((Object)gd);
            this.fLaunchConfigsCombo.select(0);
            this.fLaunchConfigsCombo.setEnabled(initLaunch);
            Button initPluginsButton = new Button(container, 16);
            initPluginsButton.setText(PDEUIMessages.PluginListPage_initializeFromPlugins);
            gd = new GridData();
            gd.horizontalSpan = 4;
            initPluginsButton.setLayoutData((Object)gd);
            initPluginsButton.setSelection(!initLaunch);
        }
        this.treePart.createControl(container, 4, true);
        this.pluginViewer = this.treePart.getTreeViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        gd = (GridData)this.treePart.getControl().getLayoutData();
        gd.horizontalIndent = 0;
        gd.heightHint = 250;
        gd.widthHint = 300;
        this.pluginViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.treePart.setSelection(new Object[0]);
        this.treePart.setEnabled(!initLaunch);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.new_feature_referenced_plugins");
        this.pluginViewer.addDoubleClickListener(event -> {
            TreeItem firstTI = this.pluginViewer.getTree().getSelection()[0];
            this.treePart.getTreeViewer().setChecked(firstTI.getData(), !firstTI.getChecked());
            this.treePart.updateCounterLabel();
        });
    }

    public IPluginBase[] getSelectedPlugins() {
        if (this.fInitLaunchConfigButton == null || !this.fInitLaunchConfigButton.getSelection()) {
            Object[] result = this.treePart.getTreeViewer().getCheckedLeafElements();
            IPluginBase[] plugins = new IPluginBase[result.length];
            int i = 0;
            while (i < result.length) {
                IPluginModelBase model = (IPluginModelBase)result[i];
                plugins[i] = model.getPluginBase();
                ++i;
            }
            return plugins;
        }
        return new IPluginBase[0];
    }

    protected void saveSettings(IDialogSettings settings) {
        settings.put(S_INIT_LAUNCH, this.fInitLaunchConfigButton != null && this.fInitLaunchConfigButton.getSelection());
    }

    private String[] getLaunchConfigurations() {
        TreeSet<String> launcherNames = new TreeSet<String>((Comparator<String>)Collator.getInstance());
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            String[] types = new String[]{"org.eclipse.pde.ui.RuntimeWorkbench", "org.eclipse.pde.ui.EquinoxLauncher"};
            int j = 0;
            while (j < 2) {
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(types[j]);
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                int i = 0;
                while (i < configs.length) {
                    if (!DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                        launcherNames.add(configs[i].getName());
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (CoreException coreException) {}
        return launcherNames.toArray(new String[launcherNames.size()]);
    }

    public ILaunchConfiguration getSelectedLaunchConfiguration() {
        if (this.fInitLaunchConfigButton == null || !this.fInitLaunchConfigButton.getSelection()) {
            return null;
        }
        String configName = this.fLaunchConfigsCombo.getText();
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            String[] types = new String[]{"org.eclipse.pde.ui.RuntimeWorkbench", "org.eclipse.pde.ui.EquinoxLauncher"};
            int j = 0;
            while (j < 2) {
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(types[j]);
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].getName().equals(configName) && !DebugUITools.isPrivate((ILaunchConfiguration)configs[i])) {
                        return configs[i];
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    class PluginContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PluginRegistry.getActiveModels();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null && !PDECore.getDefault().areModelsInitialized()) {
                try {
                    PluginListPage.this.getContainer().run(true, false, monitor -> {
                        PDECore.getDefault().getModelManager().targetReloaded(monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

