/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.mwe.ui.workflow.util.PluginConfigurationElementUtil;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.ErrorStatement;
import org.eclipse.internal.xpand2.ast.ExpandStatement;
import org.eclipse.internal.xpand2.ast.ExpressionStatement;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xpand2.ast.ForEachStatement;
import org.eclipse.internal.xpand2.ast.IfStatement;
import org.eclipse.internal.xpand2.ast.LetStatement;
import org.eclipse.internal.xpand2.ast.ProtectStatement;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xpand2.debug.ExpandSpecial;
import org.eclipse.internal.xpand2.debug.ForEachSpecial;
import org.eclipse.internal.xpand2.debug.IfSpecial;
import org.eclipse.internal.xpand2.debug.XpandModelPresentation;
import org.eclipse.internal.xpand2.model.XpandAdvice;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.ISyntaxElement;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.expression.debug.EvaluatedElementWrapper;
import org.eclipse.internal.xtend.expression.debug.NoResourceSpecial;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xpand.ui.XpandEditorPlugin;
import org.eclipse.xpand.ui.editor.XpandEditor;
import org.eclipse.xpand.ui.internal.XpandLog;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.ui.debug.ExpressionPluginAdapter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandPluginAdapter
extends ExpressionPluginAdapter {
    private Image icon = null;

    public XpandPluginAdapter() {
        this.specials.add(new ForEachSpecial());
        this.specials.add(new ExpandSpecial());
        this.specials.add(new IfSpecial());
        this.specials.add(new NoResourceSpecial());
        this.pres = new XpandModelPresentation(this.specials);
    }

    protected String getRequiredExtension() {
        return "xpt";
    }

    public boolean canHandleType(String type) {
        return "xpand".equals(type);
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute((String)("org.eclipse.ui.editors/editor[class=" + XpandEditor.class.getName() + "]/id"));
    }

    protected List<ISyntaxElement> collectFirstLevelElements(IXtendXpandResource res) {
        XpandAdvice[] advs;
        XpandDefinition[] defs;
        if (res == null) {
            return Collections.emptyList();
        }
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        XpandDefinition[] xpandDefinitionArray = defs = ((Template)res.getExtXptResource()).getDefinitions();
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition def = xpandDefinitionArray[n2];
            result.add((ISyntaxElement)def);
            ++n2;
        }
        XpandAdvice[] xpandAdviceArray = advs = ((Template)res.getExtXptResource()).getAdvices();
        int n3 = advs.length;
        n = 0;
        while (n < n3) {
            XpandAdvice adv = xpandAdviceArray[n];
            result.add((ISyntaxElement)adv);
            ++n;
        }
        return result;
    }

    protected List<ISyntaxElement> getBody(ISyntaxElement parent) {
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        if (parent instanceof AbstractDefinition) {
            result.addAll(((AbstractDefinition)parent).getBodyAsList());
        } else if (!(parent instanceof TextStatement)) {
            if (parent instanceof FileStatement) {
                FileStatement stmt = (FileStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getTargetFileName());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ForEachStatement) {
                ForEachStatement stmt = (ForEachStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getTarget());
                result.add((ISyntaxElement)stmt.getSeparator());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof IfStatement) {
                IfStatement stmt = (IfStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getCondition());
                result.addAll(stmt.getBodyAsList());
                result.add((ISyntaxElement)stmt.getElseIf());
            } else if (parent instanceof LetStatement) {
                LetStatement stmt = (LetStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getVarValue());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ProtectStatement) {
                ProtectStatement stmt = (ProtectStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getCommentStart());
                result.add((ISyntaxElement)stmt.getCommentEnd());
                result.add((ISyntaxElement)stmt.getId());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ErrorStatement) {
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)((ErrorStatement)parent).getMessage());
            } else if (parent instanceof ExpandStatement) {
                Expression sep;
                ExpandStatement stmt = (ExpandStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.addAll(stmt.getParametersAsList());
                Expression target = ((ExpandStatement)parent).getTarget();
                if (target != null) {
                    result.add((ISyntaxElement)target);
                }
                if ((sep = ((ExpandStatement)parent).getSeparator()) != null) {
                    result.add((ISyntaxElement)sep);
                }
            } else if (parent instanceof ExpressionStatement) {
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)((ExpressionStatement)parent).getExpression());
            } else if (parent instanceof Statement) {
                XpandLog.logInfo("Implementation error: Wanted to set Breakpoint for unknown statement: " + parent.getClass().getSimpleName());
            } else {
                result.addAll(super.getBody(parent));
            }
        }
        return result;
    }

    protected ISyntaxElement findElementForPosition(IResource resource, int position, int line) {
        ISyntaxElement rootElem = this.getContainingRootElement(resource, position);
        if (rootElem == null) {
            return null;
        }
        ISyntaxElement element = null;
        List<ISyntaxElement> bodyElements = this.getBody(rootElem);
        for (ISyntaxElement item : bodyElements) {
            if (!this.contains(item, position)) continue;
            element = item;
            break;
        }
        if (element == null) {
            return rootElem;
        }
        return this.getContainingElement((SyntaxElement)element, position);
    }

    protected ISyntaxElement getContainingElement(SyntaxElement element, int position) {
        if (!this.contains((ISyntaxElement)element, position)) {
            return null;
        }
        if (element instanceof ExpandStatement) {
            return this.getContainingElementOfExpandStatement((ExpandStatement)element, position);
        }
        if (element instanceof ExpressionStatement) {
            return this.getContainingElementOfExpressionStatement((ExpressionStatement)element, position);
        }
        if (element instanceof FileStatement) {
            return this.getContainingElementOfFileStatement((FileStatement)element, position);
        }
        if (element instanceof ForEachStatement) {
            return this.getContainingElementOfForEachStatement((ForEachStatement)element, position);
        }
        if (element instanceof IfStatement) {
            return this.getContainingElementOfIfStatement((IfStatement)element, position);
        }
        if (element instanceof LetStatement) {
            return this.getContainingElementOfLetStatement((LetStatement)element, position);
        }
        if (element instanceof ProtectStatement) {
            return this.getContainingElementOfProtectStatement((ProtectStatement)element, position);
        }
        return super.getContainingElement(element, position);
    }

    private ISyntaxElement getContainingElementOfExpressionStatement(ExpressionStatement exprStatement, int position) {
        return this.getContainingElement((SyntaxElement)exprStatement.getExpression(), position);
    }

    private boolean contains(ISyntaxElement elem, int position) {
        return elem.getStart() <= position && elem.getEnd() > position;
    }

    private ISyntaxElement getContainingElementOfExpandStatement(ExpandStatement expandStatement, int position) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(expandStatement.getTarget());
        return this.getContainingChild((SyntaxElement)expandStatement, children, position);
    }

    private ISyntaxElement getContainingElementOfFileStatement(FileStatement fileStatement, int position) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(fileStatement.getTargetFileName());
        children.addAll(fileStatement.getBodyAsList());
        return this.getContainingChild((SyntaxElement)fileStatement, children, position);
    }

    private ISyntaxElement getContainingElementOfForEachStatement(ForEachStatement forStatement, int position) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(forStatement.getTarget());
        children.add(forStatement.getSeparator());
        children.addAll(forStatement.getBodyAsList());
        return this.getContainingChild((SyntaxElement)forStatement, children, position);
    }

    private ISyntaxElement getContainingElementOfIfStatement(IfStatement ifStatement, int position) {
        ArrayList<Object> children = new ArrayList<Object>();
        children.add(ifStatement.getCondition());
        children.addAll(ifStatement.getBodyAsList());
        children.add(ifStatement.getElseIf());
        return this.getContainingChild((SyntaxElement)ifStatement, children, position);
    }

    private ISyntaxElement getContainingElementOfLetStatement(LetStatement letStatement, int position) {
        ArrayList<Expression> children = new ArrayList<Expression>();
        children.add(letStatement.getVarValue());
        children.addAll(letStatement.getBodyAsList());
        return this.getContainingChild((SyntaxElement)letStatement, children, position);
    }

    private ISyntaxElement getContainingElementOfProtectStatement(ProtectStatement protStatement, int position) {
        ArrayList children = new ArrayList();
        children.addAll(protStatement.getBodyAsList());
        return this.getContainingChild((SyntaxElement)protStatement, children, position);
    }

    protected boolean isValidReturnElement(ISyntaxElement element) {
        if (element instanceof TextStatement) {
            return false;
        }
        if (element instanceof Statement) {
            return true;
        }
        return super.isValidReturnElement(element);
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/templatefile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)XpandEditorPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

