/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ecore.AbstractEcoreClassDiagramTextProvider;
import net.sourceforge.plantuml.ecore.EcoreDiagramHelper;
import net.sourceforge.plantuml.text.AbstractObjectDiagramTextProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractEcoreObjectDiagramTextProvider
extends AbstractObjectDiagramTextProvider {
    private List<EObject> eObjects = new ArrayList<EObject>();
    private EcoreDiagramHelper diagramHelper = new EcoreDiagramHelper();
    private Map<EObject, String> idMap = new HashMap<EObject, String>();
    private static String MANY_VALUE_START = "[";
    private static String MANY_VALUE_END = "]";
    protected int maxAttributeLength = 40;
    protected int maxAttributeValueLenght = 25;
    protected String truncateString = "\u2026";
    protected Collection<String> replacements = Arrays.asList("\n", "\u21b5", "\t", "\u21a6", "\b", "\u21a4", "\r", "\u2190", "\f", "\u2193");

    protected AbstractEcoreObjectDiagramTextProvider(Class<?> editorType) {
        super(editorType);
    }

    protected AbstractEcoreObjectDiagramTextProvider() {
        super(IEditingDomainProvider.class);
    }

    public boolean supportsSelection(ISelection selection) {
        return selection instanceof IStructuredSelection && !AbstractEcoreClassDiagramTextProvider.isEcoreClassDiagramObject(((IStructuredSelection)selection).getFirstElement());
    }

    protected String getDiagramText(Iterator<?> it) {
        return this.getObjectDiagramText(null, it);
    }

    protected String getDiagramText(EObject eObject) {
        return this.getObjectDiagramText(eObject, (Iterator<?>)eObject.eAllContents());
    }

    protected String getObjectDiagramText(EObject root, Iterator<?> it) {
        this.eObjects.clear();
        if (root != null) {
            this.eObjects.add(root);
        }
        while (it.hasNext()) {
            Object contained = it.next();
            if (!(contained instanceof EObject)) continue;
            this.eObjects.add((EObject)contained);
        }
        String result = this.eObjects.size() > 0 ? this.getDiagramText(GEN_ATTRIBUTES | GEN_LINKS | GEN_OBJECT_HYPERLINKS) : null;
        return result;
    }

    protected String getId(EObject eObject) {
        return this.idMap.get(eObject);
    }

    protected String getOrCreateId(EObject eObject) {
        String id = this.getId(eObject);
        if (id == null) {
            id = String.valueOf(this.idMap.keySet().size() + 1);
            this.idMap.put(eObject, id);
        }
        return id;
    }

    private void initIdMap() {
        this.idMap.clear();
        for (EObject eObject : this.eObjects) {
            this.getOrCreateId(eObject);
        }
    }

    protected String getDiagramText(int genFlags) {
        this.initIdMap();
        StringBuilder buffer = new StringBuilder();
        for (EObject eObject : this.eObjects) {
            this.appendObject(eObject, genFlags, buffer);
        }
        if (AbstractEcoreObjectDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_LINKS})) {
            for (EObject eObject : this.eObjects) {
                this.appendLinks(eObject, genFlags, buffer);
            }
        }
        return buffer.toString();
    }

    protected String getName(EObject eObject) {
        return "o" + this.getId(eObject);
    }

    protected void appendObject(EObject eObject, int genFlags, StringBuilder buffer) {
        EClass eClass = eObject.eClass();
        this.appendObjectStart(this.getOrCreateId(eObject), this.getName(eObject), this.getTypeName((EClassifier)eClass), buffer);
        if (AbstractEcoreObjectDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_ATTRIBUTES})) {
            for (EAttribute attr : eClass.getEAllAttributes()) {
                Object value = eObject.eGet((EStructuralFeature)attr);
                String valueString = this.getValueString(value, attr);
                this.appendAttribute(attr.getName(), valueString, buffer);
            }
        }
        this.appendObjectEnd(buffer);
        if (AbstractEcoreObjectDiagramTextProvider.includes((int)genFlags, (int[])new int[]{GEN_OBJECT_HYPERLINKS})) {
            String link = this.diagramHelper.getEObjectHyperlink(eObject);
            this.appendNameLink(this.getName(eObject), link, buffer);
        }
    }

    protected String getValueString(Object value, EAttribute attr) {
        String valueString = "?";
        if (attr.isMany()) {
            valueString = MANY_VALUE_START;
            for (Object element : (Iterable)value) {
                if (!valueString.equals(MANY_VALUE_START)) {
                    valueString = String.valueOf(valueString) + ", ";
                }
                valueString = String.valueOf(valueString) + this.convertToString(attr, element);
            }
            valueString = String.valueOf(valueString) + MANY_VALUE_END;
        } else {
            valueString = this.convertToString(attr, value);
        }
        valueString = this.truncate(valueString, this.maxAttributeLength, this.truncateString);
        return valueString;
    }

    private String truncate(String s, int maxLength, String ts) {
        if (s != null && s.length() > maxLength) {
            s = String.valueOf(s.substring(0, maxLength - ts.length())) + ts;
        }
        return s;
    }

    protected String convertToString(EAttribute attr, Object value) {
        String converted = EcoreUtil.convertToString((EDataType)attr.getEAttributeType(), (Object)value);
        if (value instanceof String || value instanceof Character) {
            String valueClassName;
            String quote;
            if (this.replacements != null) {
                Iterator<String> it = this.replacements.iterator();
                while (it.hasNext()) {
                    converted = converted.replace(it.next(), it.next());
                }
            }
            String string = quote = "java.lang.String".equals(valueClassName = attr.getEAttributeType().getInstanceClassName()) ? "\"" : null;
            if (quote != null) {
                converted = String.valueOf(quote) + converted + quote;
            }
        }
        converted = this.truncate(converted, this.maxAttributeValueLenght, this.truncateString);
        return converted;
    }

    protected void appendLinks(EObject eObject, int genFlags, StringBuilder buffer) {
        EClass eClass = eObject.eClass();
        for (EReference ref : eClass.getEAllReferences()) {
            Object value = eObject.eGet((EStructuralFeature)ref);
            if (ref.isContainer()) continue;
            if (ref.isMany()) {
                for (EObject element : (Iterable)value) {
                    this.appendLink(eObject, element, ref, genFlags, buffer);
                }
                continue;
            }
            if (value == null) continue;
            this.appendLink(eObject, (EObject)value, ref, genFlags, buffer);
        }
    }

    protected void appendLink(EObject eObject, EObject other, EReference ref, int genFlags, StringBuilder buffer) {
        boolean isBi;
        String otherId = this.getId(other);
        if (otherId == null) {
            otherId = this.getOrCreateId(other);
            this.appendObject(other, genFlags & ~GEN_ATTRIBUTES, buffer);
        }
        boolean bl = isBi = ref.getEOpposite() != null;
        String startRole = ref.isContainment() && isBi ? ref.getEOpposite().getName() : (ref.isContainer() ? ref.getName() : null);
        String endRole = ref.isContainer() ? null : ref.getName();
        this.appendRelation(this.getName(eObject), ref.isContainment(), startRole, "--" + (ref.isContainment() || isBi ? "" : ">"), null, this.getName(other), false, endRole, null, buffer);
    }

    protected String getTypeName(EClassifier type) {
        String typeName = null;
        if (type != null) {
            if (type instanceof EDataType) {
                typeName = type.getInstanceClassName();
            }
            if (typeName == null) {
                typeName = type.getName();
            }
        }
        return this.getSimpleName(typeName);
    }
}

