/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.IntegerObject;
import org.eclipse.app4mc.amalthea.model.ListObject;
import org.eclipse.app4mc.amalthea.model.MapObject;
import org.eclipse.app4mc.amalthea.model.ReferenceObject;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;

public final class CustomPropertyUtil {
    private static final String ARG1_MESSAGE = "First argument is null, expected instance of IAnnotatable";
    private static final String ARG2_MESSAGE = "Key is null or empty, expected non empty String";

    private CustomPropertyUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, int num) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        IntegerObject valueObject = FactoryUtil.createIntegerObject(num);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, String str) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        StringObject valueObject = FactoryUtil.createStringObject(str);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, Time time) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Time valueObject = FactoryUtil.createTime(time);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Value customPut(@NonNull IAnnotatable object, @NonNull String key, IReferable reference) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        ReferenceObject valueObject = FactoryUtil.createReferenceObject(reference);
        return (Value)object.getCustomProperties().put((Object)key, (Object)valueObject);
    }

    public static Integer customGetInteger(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (valueObject instanceof IntegerObject) {
            return ((IntegerObject)valueObject).getValue();
        }
        return null;
    }

    public static String customGetString(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (valueObject instanceof StringObject) {
            return ((StringObject)valueObject).getValue();
        }
        return null;
    }

    public static Time customGetTime(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (valueObject instanceof Time) {
            return FactoryUtil.createTime((Time)valueObject);
        }
        return null;
    }

    public static IReferable customGetReference(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
        if (valueObject instanceof ReferenceObject) {
            return ((ReferenceObject)valueObject).getValue();
        }
        return null;
    }

    public static Value customGetValue(@NonNull IAnnotatable object, @NonNull String key, char separator) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        List keys = Splitter.on((char)separator).splitToList((CharSequence)key);
        String firstKey = (String)keys.get(0);
        if (firstKey == null || firstKey.isEmpty()) {
            return null;
        }
        String[] nextKeys = keys.size() < 2 ? new String[]{} : keys.subList(1, keys.size()).toArray(new String[0]);
        return CustomPropertyUtil.customGetValue(object, firstKey, nextKeys);
    }

    public static Value customGetValue(@NonNull IAnnotatable object, @NonNull String firstKey, String ... nextKeys) {
        Preconditions.checkArgument((object != null ? 1 : 0) != 0, (Object)ARG1_MESSAGE);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)firstKey) ? 1 : 0) != 0, (Object)ARG2_MESSAGE);
        Value valueObject = (Value)object.getCustomProperties().get((Object)firstKey);
        String[] stringArray = nextKeys;
        int n = nextKeys.length;
        int n2 = 0;
        while (n2 < n) {
            EList<Value> list;
            int index;
            String key = stringArray[n2];
            if (valueObject == null) break;
            valueObject = valueObject instanceof MapObject && !Strings.isNullOrEmpty((String)key) ? (Value)((MapObject)valueObject).getEntries().get((Object)key) : (valueObject instanceof ListObject && CustomPropertyUtil.isIndex(key) ? ((index = Integer.parseInt(key)) < (list = ((ListObject)valueObject).getValues()).size() ? (Value)list.get(index) : null) : null);
            ++n2;
        }
        return valueObject;
    }

    private static boolean isIndex(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

