/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.presentation;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.model.editor.container.AmaltheaModelContainer;
import org.eclipse.app4mc.amalthea.model.editor.providers.ExtendedAmaltheaLabelProvider;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.presentation.AmaltheaEditor;
import org.eclipse.app4mc.amalthea.model.presentation.AmaltheaEditorPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.osgi.service.event.EventHandler;

public class ExtendedAmaltheaEditor
extends AmaltheaEditor {
    private static final String AMALTHEA_MODEL_EDITOR = "AMALTHEA Model Editor";
    private boolean showTypes;
    private EventHandler selectionListener = event -> {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        IEditorPart editorPart = page.getActiveEditor();
        if (!(editorPart instanceof ExtendedAmaltheaEditor)) {
            return;
        }
        editorPart.setFocus();
        Object modelElements = event.getProperty("modelElements");
        this.setSelectionToViewer((Collection)modelElements);
    };

    public boolean isShowTypesEnabled() {
        return this.showTypes;
    }

    public void enableShowTypes(boolean enabled) {
        this.showTypes = enabled;
    }

    protected void initializeEditingDomain() {
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        AmaltheaModelContainer amContainer = AmaltheaEditorUtil.getModelContainer(editorInput);
        if (amContainer != null) {
            amContainer.addEditor((EditorPart)this);
            this.adapterFactory = amContainer.getAdapterFactory();
            this.editingDomain = amContainer.getEditingDomain();
            this.addCommandStackListener(this.editingDomain.getCommandStack());
        }
    }

    private void addCommandStackListener(CommandStack commandStack) {
        commandStack.addCommandStackListener(event -> {
            Composite container = this.getContainer();
            if (container == null || container.isDisposed()) {
                return;
            }
            Display display = container.getDisplay();
            if (display == null || display.isDisposed()) {
                return;
            }
            display.asyncExec(() -> {
                this.firePropertyChange(257);
                Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                if (mostRecentCommand != null) {
                    this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                }
                Iterator i = this.propertySheetPages.iterator();
                while (i.hasNext()) {
                    PropertySheetPage propertySheetPage = (PropertySheetPage)i.next();
                    if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                        i.remove();
                        continue;
                    }
                    propertySheetPage.refresh();
                }
            });
        });
    }

    public void createPages() {
        this.createModel();
        URI uri = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Resource resource = this.editingDomain.getResourceSet().getResource(uri, false);
        if (resource != null && !resource.getContents().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setUseHashlookup(true);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            IDialogSettings dialogSettings = AmaltheaEditorPlugin.getPlugin().getDialogSettings();
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new ExtendedAmaltheaLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new DiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, dialogSettings), this));
            this.selectionViewer.setInput((Object)resource);
            this.selectionViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, "Selection");
            this.getSite().getShell().getDisplay().asyncExec(() -> {
                if (!this.getContainer().isDisposed()) {
                    this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    ExtendedAmaltheaEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(() -> ((ExtendedAmaltheaEditor)this).updateProblemIndication());
        this.addSelectionSubscriber();
    }

    protected void hideTabs() {
        super.hideTabs();
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll(resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        if (super.isSaveOnCloseNeeded()) {
            AmaltheaModelContainer amContainer = AmaltheaEditorUtil.getModelContainer(this.getEditorInput());
            return amContainer == null || amContainer.getOpenEditors().size() == 1;
        }
        return false;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        AmaltheaModelContainer amContainer = AmaltheaEditorUtil.getModelContainer(this.getEditorInput());
        if (amContainer != null) {
            for (EditorPart editor : amContainer.getOpenEditors()) {
                if (!(editor instanceof ExtendedAmaltheaEditor) || editor == this) continue;
                ((ExtendedAmaltheaEditor)editor).editorDirtyStateChanged();
            }
        }
    }

    public void editorDirtyStateChanged() {
        this.firePropertyChange(257);
    }

    public void dispose() {
        this.removeSelectionSubscriber();
        AmaltheaModelContainer amContainer = AmaltheaEditorUtil.getModelContainer(this.getEditorInput());
        if (amContainer != null) {
            amContainer.removeEditor((EditorPart)this);
        }
        super.dispose();
    }

    private void addSelectionSubscriber() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IEventBroker broker = (IEventBroker)site.getService(IEventBroker.class);
        if (broker == null) {
            return;
        }
        broker.subscribe("org/eclipse/app4mc/amalthea/editor/SELECT", this.selectionListener);
    }

    private void removeSelectionSubscriber() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IEventBroker broker = (IEventBroker)site.getService(IEventBroker.class);
        if (broker == null) {
            return;
        }
        broker.unsubscribe(this.selectionListener);
    }

    public void setSelection(ISelection selection) {
        Control control;
        super.setSelection(selection);
        if (!Util.isWindows()) {
            return;
        }
        Viewer viewer = this.getViewer();
        if (viewer != null && (control = viewer.getControl()) != null) {
            control.redraw();
        }
    }
}

