/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.addon;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.InterruptController;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.PaddingDecorator;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeRowPaintListener;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.VerticalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.tree.painter.TreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Scheduler Mapping Table", "description=Renders the scheduler mapping in a table based view"})
public class MappingModelVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(MappingModel model, Composite parent) {
        List<TableItem> data = this.createTableRows(model);
        this.addMappingTable(parent, data);
    }

    private List<TableItem> createTableRows(MappingModel model) {
        TaskScheduler ts;
        HashMap<Scheduler, TableItem> internalData = new HashMap<Scheduler, TableItem>();
        for (Scheduler scheduler : AmaltheaIndex.getElements((Notifier)model, Scheduler.class)) {
            TableItem item = new TableItem();
            internalData.put(scheduler, item);
            item.setScheduler(this.name((INamed)scheduler));
            item.setProcessingUnits(scheduler.getSchedulerAllocations().stream().map(SchedulerAllocation::getResponsibility).flatMap(Collection::stream).map(this::name).sorted().collect(Collectors.joining(System.lineSeparator())));
            if (scheduler instanceof TaskScheduler) {
                ts = (TaskScheduler)scheduler;
                item.setSubSchedulers(ts.getChildSchedulers().stream().map(this::name).sorted().collect(Collectors.joining(System.lineSeparator())));
                item.setProcesses(ts.getTaskAllocations().stream().map(TaskAllocation::getTask).filter(Objects::nonNull).map(this::name).sorted().collect(Collectors.joining(System.lineSeparator())));
            }
            if (!(scheduler instanceof InterruptController)) continue;
            InterruptController ic = (InterruptController)scheduler;
            item.setProcesses(ic.getIsrAllocations().stream().map(ISRAllocation::getIsr).filter(Objects::nonNull).map(this::name).sorted().collect(Collectors.joining(System.lineSeparator())));
        }
        for (Map.Entry entry : internalData.entrySet()) {
            Scheduler scheduler = (Scheduler)entry.getKey();
            TableItem item = (TableItem)entry.getValue();
            if (!(scheduler instanceof TaskScheduler)) continue;
            ts = (TaskScheduler)scheduler;
            item.setParent((TableItem)internalData.get(ts.getParentScheduler()));
        }
        for (TableItem tableItem : internalData.values()) {
            tableItem.getPath().add(tableItem);
            TableItem parent = tableItem.getParent();
            while (parent != null) {
                tableItem.getPath().add(0, parent);
                parent = parent.getParent();
            }
        }
        return new ArrayList<TableItem>(internalData.values());
    }

    private String name(INamed object) {
        if (object == null) {
            return "<undefined>";
        }
        if (Strings.isNullOrEmpty((String)object.getName())) {
            return "?";
        }
        return object.getName();
    }

    private void addMappingTable(Composite parent, List<TableItem> data) {
        String[] propertyNames = new String[]{"scheduler", "processingUnits", "subSchedulers", "processes"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("scheduler", "Scheduler");
        propertyToLabelMap.put("processingUnits", "Processing Units");
        propertyToLabelMap.put("subSchedulers", "Sub Schedulers");
        propertyToLabelMap.put("processes", "Processes");
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        EventList eventList = GlazedLists.eventList(data);
        TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
        SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
        TreeList treeList = new TreeList((EventList)sortedList, (TreeList.Format)new TableItemTreeFormat(), TreeList.nodesStartExpanded());
        ListDataProvider bodyDataProvider = new ListDataProvider((List)treeList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer);
        GlazedListTreeData treeData = new GlazedListTreeData(treeList);
        GlazedListTreeRowModel treeRowModel = new GlazedListTreeRowModel(treeData);
        TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)selectionLayer, (ITreeRowModel)treeRowModel);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)treeLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)viewportLayer, selectionLayer);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)rowHeaderDataProvider, 50, 20), (ILayer)viewportLayer, selectionLayer);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer);
        natTable.setBackground(GUIHelper.COLOR_WHITE);
        natTable.setTheme((ThemeConfiguration)this.createTheme());
        natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter());
        natTable.addPaintListener((PaintListener)new AutoResizeRowPaintListener(natTable, viewportLayer, (ILayer)bodyDataLayer));
    }

    private ModernNatTableThemeConfiguration createTheme() {
        ModernNatTableThemeConfiguration theme = new ModernNatTableThemeConfiguration();
        theme.defaultHAlign = HorizontalAlignmentEnum.LEFT;
        theme.defaultVAlign = VerticalAlignmentEnum.TOP;
        theme.defaultCellPainter = new PaddingDecorator((ICellPainter)new TextPainter(true, true, true), 2);
        theme.treeCellPainter = new PaddingDecorator((ICellPainter)new TextPainter(false, true, true), 2, 2, 2, 15);
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        URL leafImageUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("images/right_leaf.png"), null);
        PaddingDecorator treeImagePainter = new PaddingDecorator((ICellPainter)new TreeImagePainter(false, GUIHelper.getImage((String)"right"), GUIHelper.getImage((String)"right_down"), GUIHelper.getImageByURL((String)"right_leaf", (URL)leafImageUrl)), 5, 2, 5, 2);
        IndentedTreeImagePainter treePainter = new IndentedTreeImagePainter(15, null, CellEdgeEnum.TOP_LEFT, (ICellPainter)treeImagePainter, false, 2, false);
        theme.treeStructurePainter = new BackgroundPainter((ICellPainter)treePainter);
        PaddingDecorator treeSelectionImagePainter = new PaddingDecorator((ICellPainter)new TreeImagePainter(false, GUIHelper.getImage((String)"right_inv"), GUIHelper.getImage((String)"right_down_inv"), GUIHelper.getImageByURL((String)"right_leaf", (URL)leafImageUrl)), 5, 2, 5, 2);
        IndentedTreeImagePainter treeSelectionPainter = new IndentedTreeImagePainter(15, null, CellEdgeEnum.TOP_LEFT, (ICellPainter)treeSelectionImagePainter, false, 2, false);
        theme.treeStructureSelectionPainter = new BackgroundPainter((ICellPainter)treeSelectionPainter);
        return theme;
    }

    public class TableItem {
        private TableItem parent;
        private List<TableItem> path = new ArrayList<TableItem>();
        private String scheduler;
        private String subSchedulers;
        private String processingUnits;
        private String processes;

        public TableItem getParent() {
            return this.parent;
        }

        public void setParent(TableItem parent) {
            this.parent = parent;
        }

        public List<TableItem> getPath() {
            return this.path;
        }

        public String getScheduler() {
            return this.scheduler;
        }

        public void setScheduler(String scheduler) {
            this.scheduler = scheduler;
        }

        public String getSubSchedulers() {
            return this.subSchedulers;
        }

        public void setSubSchedulers(String subSchedulers) {
            this.subSchedulers = subSchedulers;
        }

        public String getProcessingUnits() {
            return this.processingUnits;
        }

        public void setProcessingUnits(String cores) {
            this.processingUnits = cores;
        }

        public String getProcesses() {
            return this.processes;
        }

        public void setProcesses(String processes) {
            this.processes = processes;
        }
    }

    private class TableItemTreeFormat
    implements TreeList.Format<TableItem> {
        private TableItemTreeFormat() {
        }

        public void getPath(List<TableItem> path, TableItem element) {
            path.addAll(element.getPath());
        }

        public boolean allowsChildren(TableItem element) {
            return true;
        }

        public Comparator<? super TableItem> getComparator(int depth) {
            return (i1, i2) -> ((TableItem)i1).scheduler.compareTo(((TableItem)i2).scheduler);
        }
    }
}

