/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.handler;

import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.ProcessingServiceRegistry;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.RegistryServiceWrapper;
import org.eclipse.app4mc.amalthea.model.editor.contribution.service.ProcessingService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ProcessModelStructureHandler {
    @Execute
    public void execute(Shell shell, @Named(value="app4mc.creator.model") @Named(value="app4mc.creator.model") String modelType, @Named(value="app4mc.creator.id") @Named(value="app4mc.creator.id") String creatorId, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Service ProcessingServiceRegistry registry, IEclipseContext context) {
        RegistryServiceWrapper<ProcessingService> processor = registry.getService(modelType, creatorId);
        if (selection.getFirstElement() instanceof EObject && processor != null) {
            EObject object = (EObject)selection.getFirstElement();
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)object);
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)rootContainer);
            ChangeCommandWithStatusResult command = new ChangeCommandWithStatusResult(new ChangeRecorder(), (Notifier)rootContainer, context, modelType, processor, object);
            String[] split = processor.getName().split("\\|");
            command.setLabel(split[split.length - 1].trim());
            editingDomain.getCommandStack().execute((Command)command);
            if (command.status != null) {
                MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Model Processing", (String)command.status.toString());
            }
        }
    }

    private class ChangeCommandWithStatusResult
    extends ChangeCommand {
        IEclipseContext context;
        String modelType;
        RegistryServiceWrapper<ProcessingService> processor;
        EObject object;
        Object status;

        public ChangeCommandWithStatusResult(ChangeRecorder changeRecorder, Notifier notifier, IEclipseContext context, String modelType, RegistryServiceWrapper<ProcessingService> processor, EObject object) {
            super(changeRecorder, notifier);
            this.context = context;
            this.modelType = modelType;
            this.processor = processor;
            this.object = object;
        }

        protected void doExecute() {
            IEclipseContext activeContext = this.context.createChild(String.valueOf(this.modelType) + " ProcessingModelStructure");
            activeContext.set(this.processor.getType(), (Object)this.object);
            try {
                this.status = ContextInjectionFactory.invoke((Object)this.processor.getServiceInstance(), PostConstruct.class, (IEclipseContext)activeContext);
            }
            finally {
                activeContext.dispose();
            }
        }
    }
}

