/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw;

import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwStructure;
import org.eclipse.app4mc.amalthea.visualization.hw.DiagramLocation;
import org.eclipse.app4mc.amalthea.visualization.hw.VisualizationHandler;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=HW Model Block Diagram", "description=Block Diagram Visualization for Hardware Models"})
public class HWBlockDiagramVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(HWModel hwModel, Composite parent, Shell shell, @Optional @Preference(nodePath="net.sourceforge.plantuml.eclipse", value="graphvizPath") String dotPath, final UISynchronize sync) {
        final Browser browser = new Browser(parent, 0);
        final DiagramLocation diagramLocation = new DiagramLocation((EObject)hwModel);
        if (!diagramLocation.isValid()) {
            return;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                sync.asyncExec(() -> {
                    if (!browser.isDisposed()) {
                        browser.setUrl(diagramLocation.getDiagramFilePath());
                    }
                });
            }
        };
        VisualizationHandler handler = new VisualizationHandler();
        handler.execute(shell, sync, dotPath, (List<HwStructure>)hwModel.getStructures(), diagramLocation, false, (IJobChangeListener)listener);
    }
}

