/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.contribution.handler;

import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.editor.contribution.handler.ChangeCommandWithStatusResult;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.CreationServiceRegistry;
import org.eclipse.app4mc.amalthea.model.editor.contribution.registry.RegistryServiceWrapper;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class CreateModelStructureHandler {
    @Execute
    public void execute(Shell shell, @Named(value="app4mc.creator.model") @Named(value="app4mc.creator.model") String modelType, @Named(value="app4mc.creator.id") @Named(value="app4mc.creator.id") String creatorId, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, @Service CreationServiceRegistry registry, IEclipseContext context) {
        RegistryServiceWrapper serviceWrapper = registry.getService(modelType, creatorId);
        if (serviceWrapper == null) {
            return;
        }
        Object object = this.getModelObject(selection);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)eObject);
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)rootContainer);
            ChangeCommandWithStatusResult command = new ChangeCommandWithStatusResult((Notifier)rootContainer, context, String.valueOf(modelType) + " CreateModelStructure", serviceWrapper, eObject);
            String[] split = serviceWrapper.getName().split("\\|");
            command.setLabel("Create " + split[split.length - 1].trim());
            editingDomain.getCommandStack().execute(command);
            if (command.status != null) {
                MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA Structure Creation", (String)command.status.toString());
            }
        }
    }

    private Object getModelObject(IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement instanceof EObject) {
            return selectedElement;
        }
        if (selectedElement instanceof TransientItemProvider) {
            return ((TransientItemProvider)selectedElement).getTarget();
        }
        return null;
    }
}

