/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.CallArgument;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentInstance;
import org.eclipse.app4mc.amalthea.model.ComponentPort;
import org.eclipse.app4mc.amalthea.model.Composite;
import org.eclipse.app4mc.amalthea.model.DataDependency;
import org.eclipse.app4mc.amalthea.model.DirectionType;
import org.eclipse.app4mc.amalthea.model.EnumMode;
import org.eclipse.app4mc.amalthea.model.HwAccessElement;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.HwPathElement;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.IExecutable;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.ISystem;
import org.eclipse.app4mc.amalthea.model.InterfaceKind;
import org.eclipse.app4mc.amalthea.model.LocalModeLabel;
import org.eclipse.app4mc.amalthea.model.LocalModeLabelRef;
import org.eclipse.app4mc.amalthea.model.LocalModeValue;
import org.eclipse.app4mc.amalthea.model.Mode;
import org.eclipse.app4mc.amalthea.model.ModeLabel;
import org.eclipse.app4mc.amalthea.model.ModeLabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeLiteralConst;
import org.eclipse.app4mc.amalthea.model.ModeValue;
import org.eclipse.app4mc.amalthea.model.NumericMode;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.QualifiedPort;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableParameter;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;

public class CustomPropertyDescriptorService {
    private CustomPropertyDescriptorService() {
        throw new IllegalStateException("Utility class");
    }

    public static Collection<String> getNeedEntryValuesForKey(Object object) {
        UniqueEList choiceOfValues = new UniqueEList();
        EClass type = AmaltheaPackage.eINSTANCE.getHwFeatureCategory();
        Collection objects = ItemPropertyDescriptor.getReachableObjectsOfType((EObject)((EObject)object), (EClassifier)type);
        choiceOfValues.add(null);
        objects.stream().map(obj -> ((HwFeatureCategory)obj).getName()).filter(Objects::nonNull).sorted().forEachOrdered(arg_0 -> ((UniqueEList)choiceOfValues).add(arg_0));
        return choiceOfValues;
    }

    public static Collection<RunnableParameter> getCallArgumentValuesForParameter(Object object) {
        EList parameters;
        RunnableCall call;
        if (object instanceof CallArgument && (call = ((CallArgument)object).getContainingCall()) != null && call.getRunnable() != null && !(parameters = call.getRunnable().getParameters()).isEmpty()) {
            UniqueEList choiceOfValues = new UniqueEList();
            choiceOfValues.add(null);
            choiceOfValues.addAll((Collection)parameters);
            return choiceOfValues;
        }
        return Collections.emptyList();
    }

    public static Collection<RunnableParameter> getDataDependencyValuesForParameters(Object object) {
        Runnable runnable;
        if (object instanceof DataDependency && (runnable = ((DataDependency)object).getContainingRunnable()) != null) {
            BasicEList choiceOfValues = new BasicEList();
            runnable.getParameters().stream().filter(e -> e.getDirection() == DirectionType.IN || e.getDirection() == DirectionType.INOUT).forEachOrdered(((List)choiceOfValues)::add);
            return choiceOfValues;
        }
        return Collections.emptyList();
    }

    public static Collection<CallArgument> getDataDependencyValuesForCallArguments(Object object) {
        if (object instanceof DataDependency) {
            DataDependency dependency = (DataDependency)object;
            ActivityGraph graph = null;
            Runnable runnable = dependency.getContainingRunnable();
            if (runnable != null && runnable.getActivityGraph() != null) {
                graph = runnable.getActivityGraph();
            } else {
                Process process = (Process)AmaltheaServices.getContainerOfType((EObject)dependency, Process.class);
                if (process != null && process.getActivityGraph() != null) {
                    graph = process.getActivityGraph();
                }
            }
            if (graph != null) {
                List<DirectionType> dirList = Arrays.asList(DirectionType.OUT, DirectionType.INOUT);
                return SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)graph, null, RunnableCall.class).stream().map(RunnableCall::getArguments).flatMap(Collection::stream).filter(arg -> arg.getParameter() != null).filter(arg -> dirList.contains(arg.getParameter().getDirection())).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    private static Collection<String> collectModeValueStrings(Mode mode) {
        if (mode instanceof NumericMode) {
            return null;
        }
        if (mode instanceof EnumMode) {
            return ((EnumMode)mode).getLiterals().stream().map(INamed::getName).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static Collection<String> getValuesForModeValue(Object object) {
        ModeLabel label;
        if (object instanceof ModeValue && (label = ((ModeValue)object).getLabel()) != null) {
            return CustomPropertyDescriptorService.collectModeValueStrings(label.getMode());
        }
        return Collections.emptyList();
    }

    public static Collection<String> getInitialValuesForModeLabel(Object object) {
        if (object instanceof ModeLabel) {
            return CustomPropertyDescriptorService.collectModeValueStrings(((ModeLabel)object).getMode());
        }
        return Collections.emptyList();
    }

    public static Collection<String> getValuesForModeLabelAccess(Object object) {
        ModeLabel label;
        if (object instanceof ModeLabelAccess && (label = ((ModeLabelAccess)object).getData()) != null) {
            return CustomPropertyDescriptorService.collectModeValueStrings(label.getMode());
        }
        return Collections.emptyList();
    }

    public static Collection<String> getDefaultValuesForLocalModeLabel(Object object) {
        if (object instanceof LocalModeLabel) {
            return CustomPropertyDescriptorService.collectModeValueStrings(((LocalModeLabel)object).getMode());
        }
        return Collections.emptyList();
    }

    public static Collection<ModeLiteral> getValuesForModeLiteralConst(Object object) {
        Mode mode;
        LocalModeValue container;
        if (object instanceof ModeLiteralConst && (container = (LocalModeValue)AmaltheaServices.getContainerOfType((EObject)((ModeLiteralConst)object), LocalModeValue.class)) != null && container.getLabel() != null && (mode = container.getLabel().getMode()) instanceof EnumMode) {
            return ((EnumMode)mode).getLiterals().stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Collection<LocalModeLabel> getLocalLabelsOfExecutable(IExecutable executable) {
        if (executable != null) {
            BasicEList choices = new BasicEList();
            choices.addAll(executable.getLocalLabels());
            return choices;
        }
        return Collections.emptyList();
    }

    public static Collection<LocalModeLabel> getLabelsForLocalModeValue(Object object) {
        if (object instanceof LocalModeValue) {
            LocalModeValue localModeValue = (LocalModeValue)object;
            if (localModeValue.eContainer() instanceof RunnableCall) {
                Runnable runnable = ((RunnableCall)localModeValue.eContainer()).getRunnable();
                return CustomPropertyDescriptorService.getLocalLabelsOfExecutable((IExecutable)runnable);
            }
            IExecutable executable = (IExecutable)AmaltheaServices.getContainerOfType((EObject)localModeValue, IExecutable.class);
            return CustomPropertyDescriptorService.getLocalLabelsOfExecutable(executable);
        }
        return Collections.emptyList();
    }

    public static Collection<LocalModeLabel> getValuesForLocalModeLabelRef(Object object) {
        if (object instanceof LocalModeLabelRef) {
            IExecutable executable = (IExecutable)AmaltheaServices.getContainerOfType((EObject)((LocalModeLabelRef)object), IExecutable.class);
            return CustomPropertyDescriptorService.getLocalLabelsOfExecutable(executable);
        }
        return Collections.emptyList();
    }

    public static Collection<HwPathElement> filterValuesForPathElements(Object object, Collection<?> choices) {
        HwAccessElement accessElement;
        if (object instanceof HwAccessPath && (accessElement = ((HwAccessPath)object).getContainingAccessElement()) != null) {
            ProcessingUnit source = accessElement.getSource();
            return choices.stream().filter(HwPathElement.class::isInstance).map(HwPathElement.class::cast).filter(e -> e != source).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static Component getComponent(QualifiedPort qualPort) {
        if (qualPort.getInstance() == null) {
            return (Component)AmaltheaServices.getContainerOfType((EObject)qualPort, Composite.class);
        }
        return qualPort.getInstance().getType();
    }

    public static Collection<ComponentInstance> getValuesForComponentInstance(Object object) {
        ISystem container;
        if (object instanceof QualifiedPort && (container = (ISystem)AmaltheaServices.getContainerOfType((EObject)((EObject)object), ISystem.class)) != null) {
            BasicEList choices = new BasicEList();
            choices.add(null);
            choices.addAll(container.getComponentInstances());
            return choices;
        }
        return Collections.emptyList();
    }

    public static Collection<ComponentPort> getValuesForComponentPort(Object object) {
        QualifiedPort qPort;
        Component component;
        if (object instanceof QualifiedPort && (component = CustomPropertyDescriptorService.getComponent(qPort = (QualifiedPort)object)) != null) {
            BasicEList choices = new BasicEList();
            choices.add(null);
            choices.addAll(CustomPropertyDescriptorService.filterPortList((List<ComponentPort>)component.getPorts(), qPort));
            return choices;
        }
        return Collections.emptyList();
    }

    private static List<ComponentPort> filterPortList(List<ComponentPort> ports, QualifiedPort qualPort) {
        boolean isInnerPort = qualPort.getInstance() != null;
        List<InterfaceKind> provideList = Arrays.asList(InterfaceKind.PROVIDES, InterfaceKind.PROVIDES_REQUIRES, InterfaceKind._UNDEFINED_);
        List<InterfaceKind> requireList = Arrays.asList(InterfaceKind.REQUIRES, InterfaceKind.PROVIDES_REQUIRES, InterfaceKind._UNDEFINED_);
        EStructuralFeature feature = qualPort.eContainingFeature();
        AmaltheaPackage amPackage = AmaltheaPackage.eINSTANCE;
        if (amPackage.getConnector_SourcePort().equals(feature)) {
            if (isInnerPort) {
                return ports.stream().filter(e -> provideList.contains(e.getKind())).collect(Collectors.toList());
            }
            return ports.stream().filter(e -> requireList.contains(e.getKind())).collect(Collectors.toList());
        }
        if (amPackage.getConnector_TargetPort().equals(feature)) {
            if (isInnerPort) {
                return ports.stream().filter(e -> requireList.contains(e.getKind())).collect(Collectors.toList());
            }
            return ports.stream().filter(e -> provideList.contains(e.getKind())).collect(Collectors.toList());
        }
        if (amPackage.getISystem_GroundedPorts().equals(feature)) {
            if (isInnerPort) {
                return ports;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

