/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util.stimuli;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.PeriodicBurstStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.PeriodicSyntheticStimulus;
import org.eclipse.app4mc.amalthea.model.RelativePeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.VariableRateStimulus;
import org.eclipse.app4mc.amalthea.model.util.FactoryUtil;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMPeriodic;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMPeriodicBurst;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMPeriodicRelative;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMPeriodicSynthetic;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMSingle;
import org.eclipse.app4mc.amalthea.model.util.stimuli.EMVariableRate;
import org.eclipse.app4mc.amalthea.model.util.stimuli.IEventModel;

public class EventModelFactory {
    private static final Time ZEROMS = FactoryUtil.createTime("0ms");

    private EventModelFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static IEventModel of(Stimulus s) {
        if (s instanceof PeriodicStimulus) {
            return EventModelFactory.ofStimuli((PeriodicStimulus)s);
        }
        if (s instanceof PeriodicSyntheticStimulus) {
            return EventModelFactory.ofStimuli((PeriodicSyntheticStimulus)s);
        }
        if (s instanceof RelativePeriodicStimulus) {
            return EventModelFactory.ofStimuli((RelativePeriodicStimulus)s);
        }
        if (s instanceof PeriodicBurstStimulus) {
            return EventModelFactory.ofStimuli((PeriodicBurstStimulus)s);
        }
        if (s instanceof SingleStimulus) {
            return EventModelFactory.ofStimuli((SingleStimulus)s);
        }
        if (s instanceof VariableRateStimulus) {
            return EventModelFactory.ofStimuli((VariableRateStimulus)s);
        }
        return null;
    }

    private static IEventModel ofStimuli(PeriodicStimulus s) {
        EMPeriodic em = new EMPeriodic();
        em.setRecurrence(s.getRecurrence());
        if (s.getMinDistance() == null) {
            em.setMinDistance(FactoryUtil.createTime("0ms"));
        } else {
            em.setMinDistance(s.getMinDistance());
        }
        if (s.getJitter() == null) {
            em.setJitter(FactoryUtil.createTime("0ms"));
        } else {
            em.setJitter(s.getJitter().getUpperBound());
        }
        return em;
    }

    private static IEventModel ofStimuli(PeriodicSyntheticStimulus s) {
        EMPeriodicSynthetic em = new EMPeriodicSynthetic();
        em.setOuterPeriod(s.getRecurrence());
        em.setEntries((List<Time>)s.getOccurrenceTimes());
        return em;
    }

    private static IEventModel ofStimuli(RelativePeriodicStimulus periodicRelative) {
        EMPeriodicRelative em = new EMPeriodicRelative();
        em.setLowerBoundDistance(periodicRelative.getNextOccurrence().getLowerBound());
        em.setUpperBoundDistance(periodicRelative.getNextOccurrence().getUpperBound());
        return em;
    }

    private static IEventModel ofStimuli(PeriodicBurstStimulus s) {
        EMPeriodicBurst em = new EMPeriodicBurst();
        if (EventModelFactory.isNullOrZero(s.getRecurrence()) || EventModelFactory.isNullOrZero(s.getBurstLength())) {
            return null;
        }
        em.setOuterPeriod(s.getRecurrence());
        em.setBurstLength(s.getBurstLength());
        if (!EventModelFactory.isNullOrZero(s.getOccurrenceMinDistance()) && !EventModelFactory.isNullOrZero(em.getBurstLength()) && s.getOccurrenceMinDistance().multiply((long)s.getOccurrenceCount() - 1L).compareTo(em.getBurstLength()) > 0) {
            em.setOccurrenceCount((int)Math.ceil(em.getBurstLength().divide(s.getOccurrenceMinDistance())));
        } else {
            em.setOccurrenceCount(s.getOccurrenceCount());
        }
        if (s.getOccurrenceMinDistance() != null) {
            em.setMinDistance(s.getOccurrenceMinDistance());
            em.setDeltaBurst(em.getBurstLength().subtract(em.getMinDistance().multiply(em.getOccurrenceCount() - 1L)));
        } else {
            em.setMinDistance(ZEROMS);
            em.setDeltaBurst(ZEROMS);
        }
        return em;
    }

    private static IEventModel ofStimuli(SingleStimulus singleStimulus) {
        EMSingle em = new EMSingle();
        return em;
    }

    private static IEventModel ofStimuli(VariableRateStimulus s) {
        EMVariableRate em = new EMVariableRate();
        em.setStep(s.getStep());
        em.setLowerBoundOccurrences(s.getOccurrencesPerStep().getLowerBound());
        em.setUpperBoundOccurrences(s.getOccurrencesPerStep().getUpperBound());
        em.setAverageBoundOccurrences(s.getOccurrencesPerStep().getAverage());
        return em;
    }

    public static Time max(Time a, Time b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public static Time min(Time a, Time b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    public static boolean isNullOrZero(Time t) {
        return t == null || t.getValue().compareTo(BigInteger.ZERO) == 0;
    }
}

