/**
 * *******************************************************************************
 *  Copyright (c) 2015-2021 Robert Bosch GmbH and others.
 * 
 *  This program and the accompanying materials are made
 *  available under the terms of the Eclipse Public License 2.0
 *  which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 *  SPDX-License-Identifier: EPL-2.0
 * 
 *     Generated using Eclipse EMF
 * 
 * *******************************************************************************
 */
package org.eclipse.app4mc.amalthea.model.impl;

import java.util.Collection;

import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentPort;
import org.eclipse.app4mc.amalthea.model.ComponentStructure;
import org.eclipse.app4mc.amalthea.model.IComponentStructureMember;
import org.eclipse.app4mc.amalthea.model.INamespaceMember;
import org.eclipse.app4mc.amalthea.model.ITaggable;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Namespace;
import org.eclipse.app4mc.amalthea.model.OsEvent;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.Tag;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Component</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getTags <em>Tags</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getNamespace <em>Namespace</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getStructure <em>Structure</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getPorts <em>Ports</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getProcesses <em>Processes</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getRunnables <em>Runnables</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getLabels <em>Labels</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getSemaphores <em>Semaphores</em>}</li>
 *   <li>{@link org.eclipse.app4mc.amalthea.model.impl.ComponentImpl#getOsEvents <em>Os Events</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ComponentImpl extends ReferableBaseObjectImpl implements Component {
	/**
	 * The cached value of the '{@link #getTags() <em>Tags</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTags()
	 * @generated
	 * @ordered
	 */
	protected EList<Tag> tags;

	/**
	 * The cached value of the '{@link #getNamespace() <em>Namespace</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNamespace()
	 * @generated
	 * @ordered
	 */
	protected Namespace namespace;

	/**
	 * The cached value of the '{@link #getStructure() <em>Structure</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStructure()
	 * @generated
	 * @ordered
	 */
	protected ComponentStructure structure;

	/**
	 * The cached value of the '{@link #getPorts() <em>Ports</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPorts()
	 * @generated
	 * @ordered
	 */
	protected EList<ComponentPort> ports;

	/**
	 * The cached value of the '{@link #getProcesses() <em>Processes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcesses()
	 * @generated
	 * @ordered
	 */
	protected EList<AbstractProcess> processes;

	/**
	 * The cached value of the '{@link #getRunnables() <em>Runnables</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunnables()
	 * @generated
	 * @ordered
	 */
	protected EList<org.eclipse.app4mc.amalthea.model.Runnable> runnables;

	/**
	 * The cached value of the '{@link #getLabels() <em>Labels</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLabels()
	 * @generated
	 * @ordered
	 */
	protected EList<Label> labels;

	/**
	 * The cached value of the '{@link #getSemaphores() <em>Semaphores</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSemaphores()
	 * @generated
	 * @ordered
	 */
	protected EList<Semaphore> semaphores;

	/**
	 * The cached value of the '{@link #getOsEvents() <em>Os Events</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOsEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<OsEvent> osEvents;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AmaltheaPackage.eINSTANCE.getComponent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Tag> getTags() {
		if (tags == null) {
			tags = new EObjectResolvingEList<Tag>(Tag.class, this, AmaltheaPackage.COMPONENT__TAGS);
		}
		return tags;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Namespace getNamespace() {
		if (namespace != null && namespace.eIsProxy()) {
			InternalEObject oldNamespace = (InternalEObject)namespace;
			namespace = (Namespace)eResolveProxy(oldNamespace);
			if (namespace != oldNamespace) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, AmaltheaPackage.COMPONENT__NAMESPACE, oldNamespace, namespace));
			}
		}
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Namespace basicGetNamespace() {
		return namespace;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNamespace(Namespace newNamespace) {
		Namespace oldNamespace = namespace;
		namespace = newNamespace;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AmaltheaPackage.COMPONENT__NAMESPACE, oldNamespace, namespace));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComponentStructure getStructure() {
		if (structure != null && structure.eIsProxy()) {
			InternalEObject oldStructure = (InternalEObject)structure;
			structure = (ComponentStructure)eResolveProxy(oldStructure);
			if (structure != oldStructure) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, AmaltheaPackage.COMPONENT__STRUCTURE, oldStructure, structure));
			}
		}
		return structure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentStructure basicGetStructure() {
		return structure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStructure(ComponentStructure newStructure) {
		ComponentStructure oldStructure = structure;
		structure = newStructure;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AmaltheaPackage.COMPONENT__STRUCTURE, oldStructure, structure));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ComponentPort> getPorts() {
		if (ports == null) {
			ports = new EObjectContainmentWithInverseEList<ComponentPort>(ComponentPort.class, this, AmaltheaPackage.COMPONENT__PORTS, AmaltheaPackage.COMPONENT_PORT__CONTAINING_COMPONENT);
		}
		return ports;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AbstractProcess> getProcesses() {
		if (processes == null) {
			processes = new EObjectResolvingEList<AbstractProcess>(AbstractProcess.class, this, AmaltheaPackage.COMPONENT__PROCESSES);
		}
		return processes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<org.eclipse.app4mc.amalthea.model.Runnable> getRunnables() {
		if (runnables == null) {
			runnables = new EObjectResolvingEList<org.eclipse.app4mc.amalthea.model.Runnable>(org.eclipse.app4mc.amalthea.model.Runnable.class, this, AmaltheaPackage.COMPONENT__RUNNABLES);
		}
		return runnables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Label> getLabels() {
		if (labels == null) {
			labels = new EObjectResolvingEList<Label>(Label.class, this, AmaltheaPackage.COMPONENT__LABELS);
		}
		return labels;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Semaphore> getSemaphores() {
		if (semaphores == null) {
			semaphores = new EObjectResolvingEList<Semaphore>(Semaphore.class, this, AmaltheaPackage.COMPONENT__SEMAPHORES);
		}
		return semaphores;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<OsEvent> getOsEvents() {
		if (osEvents == null) {
			osEvents = new EObjectResolvingEList<OsEvent>(OsEvent.class, this, AmaltheaPackage.COMPONENT__OS_EVENTS);
		}
		return osEvents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__PORTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getPorts()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__PORTS:
				return ((InternalEList<?>)getPorts()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__TAGS:
				return getTags();
			case AmaltheaPackage.COMPONENT__NAMESPACE:
				if (resolve) return getNamespace();
				return basicGetNamespace();
			case AmaltheaPackage.COMPONENT__STRUCTURE:
				if (resolve) return getStructure();
				return basicGetStructure();
			case AmaltheaPackage.COMPONENT__PORTS:
				return getPorts();
			case AmaltheaPackage.COMPONENT__PROCESSES:
				return getProcesses();
			case AmaltheaPackage.COMPONENT__RUNNABLES:
				return getRunnables();
			case AmaltheaPackage.COMPONENT__LABELS:
				return getLabels();
			case AmaltheaPackage.COMPONENT__SEMAPHORES:
				return getSemaphores();
			case AmaltheaPackage.COMPONENT__OS_EVENTS:
				return getOsEvents();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__TAGS:
				getTags().clear();
				getTags().addAll((Collection<? extends Tag>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__NAMESPACE:
				setNamespace((Namespace)newValue);
				return;
			case AmaltheaPackage.COMPONENT__STRUCTURE:
				setStructure((ComponentStructure)newValue);
				return;
			case AmaltheaPackage.COMPONENT__PORTS:
				getPorts().clear();
				getPorts().addAll((Collection<? extends ComponentPort>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__PROCESSES:
				getProcesses().clear();
				getProcesses().addAll((Collection<? extends AbstractProcess>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__RUNNABLES:
				getRunnables().clear();
				getRunnables().addAll((Collection<? extends org.eclipse.app4mc.amalthea.model.Runnable>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__LABELS:
				getLabels().clear();
				getLabels().addAll((Collection<? extends Label>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__SEMAPHORES:
				getSemaphores().clear();
				getSemaphores().addAll((Collection<? extends Semaphore>)newValue);
				return;
			case AmaltheaPackage.COMPONENT__OS_EVENTS:
				getOsEvents().clear();
				getOsEvents().addAll((Collection<? extends OsEvent>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__TAGS:
				getTags().clear();
				return;
			case AmaltheaPackage.COMPONENT__NAMESPACE:
				setNamespace((Namespace)null);
				return;
			case AmaltheaPackage.COMPONENT__STRUCTURE:
				setStructure((ComponentStructure)null);
				return;
			case AmaltheaPackage.COMPONENT__PORTS:
				getPorts().clear();
				return;
			case AmaltheaPackage.COMPONENT__PROCESSES:
				getProcesses().clear();
				return;
			case AmaltheaPackage.COMPONENT__RUNNABLES:
				getRunnables().clear();
				return;
			case AmaltheaPackage.COMPONENT__LABELS:
				getLabels().clear();
				return;
			case AmaltheaPackage.COMPONENT__SEMAPHORES:
				getSemaphores().clear();
				return;
			case AmaltheaPackage.COMPONENT__OS_EVENTS:
				getOsEvents().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AmaltheaPackage.COMPONENT__TAGS:
				return tags != null && !tags.isEmpty();
			case AmaltheaPackage.COMPONENT__NAMESPACE:
				return namespace != null;
			case AmaltheaPackage.COMPONENT__STRUCTURE:
				return structure != null;
			case AmaltheaPackage.COMPONENT__PORTS:
				return ports != null && !ports.isEmpty();
			case AmaltheaPackage.COMPONENT__PROCESSES:
				return processes != null && !processes.isEmpty();
			case AmaltheaPackage.COMPONENT__RUNNABLES:
				return runnables != null && !runnables.isEmpty();
			case AmaltheaPackage.COMPONENT__LABELS:
				return labels != null && !labels.isEmpty();
			case AmaltheaPackage.COMPONENT__SEMAPHORES:
				return semaphores != null && !semaphores.isEmpty();
			case AmaltheaPackage.COMPONENT__OS_EVENTS:
				return osEvents != null && !osEvents.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == ITaggable.class) {
			switch (derivedFeatureID) {
				case AmaltheaPackage.COMPONENT__TAGS: return AmaltheaPackage.ITAGGABLE__TAGS;
				default: return -1;
			}
		}
		if (baseClass == INamespaceMember.class) {
			switch (derivedFeatureID) {
				case AmaltheaPackage.COMPONENT__NAMESPACE: return AmaltheaPackage.INAMESPACE_MEMBER__NAMESPACE;
				default: return -1;
			}
		}
		if (baseClass == IComponentStructureMember.class) {
			switch (derivedFeatureID) {
				case AmaltheaPackage.COMPONENT__STRUCTURE: return AmaltheaPackage.ICOMPONENT_STRUCTURE_MEMBER__STRUCTURE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == ITaggable.class) {
			switch (baseFeatureID) {
				case AmaltheaPackage.ITAGGABLE__TAGS: return AmaltheaPackage.COMPONENT__TAGS;
				default: return -1;
			}
		}
		if (baseClass == INamespaceMember.class) {
			switch (baseFeatureID) {
				case AmaltheaPackage.INAMESPACE_MEMBER__NAMESPACE: return AmaltheaPackage.COMPONENT__NAMESPACE;
				default: return -1;
			}
		}
		if (baseClass == IComponentStructureMember.class) {
			switch (baseFeatureID) {
				case AmaltheaPackage.ICOMPONENT_STRUCTURE_MEMBER__STRUCTURE: return AmaltheaPackage.COMPONENT__STRUCTURE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //ComponentImpl
