/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class GroupMultiColumnReorderCommand
extends MultiColumnReorderCommand {
    private GroupModel.Group groupToRight;

    public GroupMultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition, GroupModel.Group groupToRight) {
        this(layer, fromColumnPositions, toColumnPosition < layer.getColumnCount() ? toColumnPosition : toColumnPosition - 1, toColumnPosition < layer.getColumnCount(), groupToRight);
    }

    public GroupMultiColumnReorderCommand(ILayer layer, List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge, GroupModel.Group groupToRight) {
        super(layer, fromColumnPositions, toColumnPosition, reorderToLeftEdge);
        this.groupToRight = groupToRight;
    }

    protected GroupMultiColumnReorderCommand(GroupMultiColumnReorderCommand command) {
        super(command);
        this.groupToRight = command.groupToRight;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            if (this.groupToRight != null) {
                int toLeftPosition = this.toColumnPositionCoordinate.columnPosition - 1;
                int toLeftIndex = this.toColumnPositionCoordinate.getLayer().getColumnIndexByPosition(toLeftPosition);
                while (this.groupToRight.hasMember(toLeftIndex)) {
                    --this.toColumnPositionCoordinate.columnPosition;
                    toLeftIndex = this.toColumnPositionCoordinate.getLayer().getColumnIndexByPosition(--toLeftPosition);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public GroupMultiColumnReorderCommand cloneCommand() {
        return new GroupMultiColumnReorderCommand(this);
    }
}

