/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validations.inchron.sw;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.OperatingSystem;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableAllocation;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.validation.core.AmaltheaValidation;
import org.eclipse.app4mc.validation.annotation.Validation;
import org.eclipse.app4mc.validation.core.ValidationDiagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;

@Validation(id="Inchron-SW-Runnable-NotAllocated-DifferentOS", checks={"Runnable cannot be scheduled by more than one OS"})
public class InchronSWInvalidRunnableAllocation
extends AmaltheaValidation {
    public EClassifier getEClassifier() {
        return ePackage.getRunnable();
    }

    public void validate(EObject eObject, List<ValidationDiagnostic> results) {
        if (eObject instanceof Runnable) {
            Runnable run = (Runnable)eObject;
            Set runAllocations = AmaltheaIndex.getReferringObjects((EObject)run, RunnableAllocation.class);
            HashSet<OperatingSystem> osSet = new HashSet<OperatingSystem>();
            for (RunnableAllocation runAllocation : runAllocations) {
                Scheduler sched = runAllocation.getScheduler();
                if (sched == null || !(sched.eContainer() instanceof OperatingSystem)) continue;
                OperatingSystem os = (OperatingSystem)sched.eContainer();
                osSet.add(os);
            }
            ArrayList<String> ar = new ArrayList<String>();
            if (osSet.size() > 1) {
                for (OperatingSystem os2 : osSet) {
                    if (os2.getName() == null) continue;
                    ar.add(os2.getName());
                }
                Collections.sort(ar);
                String str = String.join((CharSequence)",", ar);
                this.addIssue(results, (EObject)run, null, "Runnable " + this.name((INamed)run) + " is scheduled by more than one operating system: " + str);
            }
        }
    }
}

