/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.app4mc.atdb.MetricAggregation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class EventChainMetricCalculator
implements IRunnableWithProgress {
    private static final Map<String, String> metricCalculationStmts = new LinkedHashMap<String, String>();
    private final ATDBConnection con;

    static {
        Stream.of("Age", "Reaction").forEach(latencyType -> {
            String latencyName = String.valueOf(latencyType.toLowerCase()) + "Latency";
            metricCalculationStmts.put(latencyName, "INSERT OR IGNORE INTO entityInstanceMetricValue SELECT entityId, entityInstance, (SELECT id FROM metric WHERE name = '" + latencyName + "'), responseTimestamp - stimulusTimestamp FROM eventChainInstanceInfo " + "WHERE is" + latencyType + ";");
            Stream.of(MetricAggregation.values()).forEach(kind -> {
                String metricName = String.valueOf(latencyName) + "_" + kind;
                String aggregateFunction = kind.getSQLStr("value");
                metricCalculationStmts.put(metricName, "INSERT OR IGNORE INTO entityMetricValue SELECT entityId, (SELECT id FROM metric WHERE name = '" + metricName + "'), " + aggregateFunction + " FROM entityInstanceMetricValue WHERE (SELECT is" + latencyType + " FROM " + "eventChainInstanceInfo WHERE eventChainInstanceInfo.entityId = entityInstanceMetricValue.entityId AND " + "eventChainInstanceInfo.entityInstance = entityInstanceMetricValue.entityInstance) " + "GROUP BY entityId;");
            });
        });
    }

    public EventChainMetricCalculator(ATDBConnection con) {
        this.con = con;
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)"Calculating event chain metrics...", (int)3);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Statement mStmt = this.con.createStatement();){
                Bundle bundle = FrameworkUtil.getBundle(EventChainMetricCalculator.class);
                String pathInBundle = String.valueOf(EventChainMetricCalculator.class.getPackage().getName().replace('.', '/')) + "/ecinststatements.sql";
                URL fileURL = bundle.getResource(pathInBundle);
                String ecInstCalculationSQL = EventChainMetricCalculator.loadStringFromFile(fileURL);
                if (ecInstCalculationSQL.length() == 0) {
                    return;
                }
                this.con.executeUpdate(ecInstCalculationSQL);
                subMon.worked(1);
                this.con.executeBatchUpdate(atdbCon -> {
                    for (Map.Entry<String, String> metricCalculationStmt : metricCalculationStmts.entrySet()) {
                        atdbCon.insertMetric(metricCalculationStmt.getKey(), "time");
                        mStmt.addBatch(metricCalculationStmt.getValue());
                    }
                });
                subMon.worked(1);
                this.con.executeBatchStatements(new Statement[]{mStmt});
                subMon.worked(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new InvocationTargetException(e);
        }
    }

    /*
     * Loose catch block
     */
    private static String loadStringFromFile(URL fileURL) {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                String string;
                ByteArrayOutputStream bAOS;
                InputStream fileIS;
                block19: {
                    block18: {
                        int length;
                        fileIS = fileURL.openStream();
                        bAOS = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        while ((length = fileIS.read(buffer)) != -1) {
                            bAOS.write(buffer, 0, length);
                        }
                        string = bAOS.toString();
                        if (bAOS == null) break block18;
                        bAOS.close();
                    }
                    if (fileIS == null) break block19;
                    fileIS.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (bAOS != null) {
                                bAOS.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fileIS != null) {
                                fileIS.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

