/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Map;

public abstract class AbstractDiagramIntent<T>
extends net.sourceforge.plantuml.util.AbstractDiagramIntent<T> {
    private int indentLevel = 0;
    private final String indentString = "\t";
    protected static final String RELATION_LINE = "--";

    public AbstractDiagramIntent(T source) {
        super(source);
    }

    public AbstractDiagramIntent(T source, String label) {
        super(source, label);
    }

    protected String getStartPlantUml() {
        return "@startuml";
    }

    protected String getEndPlantUml() {
        return "@enduml";
    }

    public String ensureDiagramText(String diagramText) {
        if (diagramText != null) {
            if (!(diagramText = diagramText.trim()).startsWith(this.getStartPlantUml())) {
                diagramText = String.valueOf(this.getStartPlantUml()) + "\n" + diagramText;
            }
            if (!diagramText.endsWith(this.getEndPlantUml())) {
                diagramText = String.valueOf(diagramText) + "\n" + this.getEndPlantUml();
            }
        }
        return diagramText;
    }

    protected void indent(int d) {
        this.indentLevel += d;
    }

    protected void indent(StringBuilder buffer) {
        int i = 0;
        while (i < this.indentLevel) {
            buffer.append("\t");
            ++i;
        }
    }

    protected static boolean includes(int flags, int ... bits) {
        int i = 0;
        while (i < bits.length) {
            if ((flags & bits[i]) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void appendSkinParams(Map<String, String> skinParams, StringBuilder buffer) {
        this.appendSkinParams(null, skinParams, buffer);
    }

    protected void appendSkinParams(String qualifier, Map<String, String> skinParams, StringBuilder buffer) {
        if (qualifier != null) {
            buffer.append("skinparam");
            buffer.append(" ");
            buffer.append(qualifier);
            buffer.append(" {\n");
        }
        for (String param : skinParams.keySet()) {
            if (qualifier != null) {
                buffer.append("\t");
                if (param.startsWith(qualifier)) {
                    param = param.substring(qualifier.length());
                }
            } else {
                buffer.append("skinparam ");
            }
            buffer.append(param);
            buffer.append(" ");
            buffer.append(skinParams.get(param));
            buffer.append("\n");
        }
        if (qualifier != null) {
            buffer.append("}\n");
        }
    }

    protected void appendLink(String link, boolean isMember, StringBuilder result) {
        if (link != null) {
            result.append(" [[");
            if (isMember) {
                result.append("[");
            }
            result.append(link);
            if (isMember) {
                result.append("]");
            }
            result.append("]]");
        }
    }

    protected String getSimpleName(String name) {
        int pos = name != null ? name.lastIndexOf(46) : -1;
        return pos >= 0 ? name.substring(pos + 1) : name;
    }

    protected String getLogicalName(String name) {
        StringBuilder builder = null;
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c)) {
                if (builder != null) {
                    builder.append(c);
                }
            } else {
                if (builder == null) {
                    builder = new StringBuilder(name.substring(0, i));
                }
                builder.append("_");
            }
            ++i;
        }
        return builder != null ? builder.toString() : name;
    }

    protected void appendRelation(String start, boolean cont1, String startLabel, String relation, String direction, String end, boolean cont2, String endLabel, String label, StringBuilder buffer) {
        int pos;
        buffer.append(this.getLogicalName(start));
        if (startLabel != null) {
            buffer.append(" \"");
            buffer.append(startLabel);
            buffer.append("\"");
        }
        buffer.append(" ");
        if (cont1) {
            buffer.append("*");
        }
        if (direction != null && (pos = relation.indexOf(RELATION_LINE)) >= 0) {
            pos = RELATION_LINE.length() / 2;
            relation = relation.replace(RELATION_LINE, String.valueOf(RELATION_LINE.substring(0, pos)) + direction + RELATION_LINE.substring(pos));
        }
        buffer.append(relation);
        if (cont2) {
            buffer.append("*");
        }
        if (endLabel != null) {
            buffer.append(" \"");
            buffer.append(endLabel);
            buffer.append("\"");
        }
        buffer.append(" ");
        buffer.append(this.getLogicalName(end));
        if (label != null) {
            buffer.append(" : ");
            buffer.append(label);
        }
        buffer.append("\n");
    }

    protected void appendNameLink(String name, String link, StringBuilder buffer) {
        if (link != null) {
            buffer.append("url of ");
            buffer.append(name);
            buffer.append(" is ");
            this.appendLink(link, false, buffer);
            buffer.append("\n");
        }
    }
}

