/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Collection;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.eclipse.utils.WorkspaceDiagramIntentProviderContext;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntentContext;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDiagramIntentProvider
implements DiagramIntentProvider {
    private Class<?> partType = null;

    public AbstractDiagramIntentProvider() {
    }

    public AbstractDiagramIntentProvider(Class<?> partType) {
        if (partType != null) {
            if (IViewPart.class.isAssignableFrom(partType)) {
                this.setViewType(partType);
            } else {
                this.setEditorType(partType);
            }
        }
    }

    public void setEditorType(Class<?> editorType) {
        this.partType = editorType;
    }

    public void setViewType(Class<?> viewType) {
        this.partType = viewType;
    }

    protected boolean isWorkbenchPart(IWorkbenchPart part, Class<?> partType) {
        if (partType != null) {
            if (partType.isInstance(part)) {
                return true;
            }
            return part.getAdapter(partType) != null;
        }
        return true;
    }

    protected <T> T getWorkbenchPart(IWorkbenchPart part, Class<T> partType) {
        return (T)(partType.isInstance(part) ? part : part.getAdapter(partType));
    }

    protected boolean supportsEditor(IEditorPart editorPart) {
        return this.isWorkbenchPart((IWorkbenchPart)editorPart, this.partType);
    }

    protected boolean supportsView(IViewPart viewPart) {
        return this.isWorkbenchPart((IWorkbenchPart)viewPart, this.partType);
    }

    protected Boolean supportsSelection(ISelection selection) {
        return null;
    }

    protected Boolean supportsPath(IPath path) {
        return null;
    }

    protected String getStartPlantUml() {
        return "@startuml";
    }

    protected String getEndPlantUml() {
        return "@enduml";
    }

    public Collection<? extends DiagramIntent> getDiagramInfos(DiagramIntentContext context) {
        WorkspaceDiagramIntentProviderContext workspaceContext;
        if (context instanceof WorkbenchPartDiagramIntentProviderContext) {
            WorkbenchPartDiagramIntentProviderContext workbenchContext = (WorkbenchPartDiagramIntentProviderContext)context;
            IWorkbenchPart workbenchPart = workbenchContext.getWorkbenchPart();
            if (workbenchPart instanceof IEditorPart) {
                if (!this.supportsEditor((IEditorPart)workbenchPart)) {
                    return null;
                }
                if (workbenchContext.getSelection() != null && Boolean.FALSE.equals(this.supportsSelection(workbenchContext.getSelection()))) {
                    return null;
                }
                return this.getDiagramInfos(workbenchContext);
            }
            if (!this.supportsView((IViewPart)workbenchPart)) {
                return null;
            }
            if (workbenchContext.getSelection() != null && Boolean.FALSE.equals(this.supportsSelection(workbenchContext.getSelection()))) {
                return null;
            }
            return this.getDiagramInfos(workbenchContext);
        }
        if (context instanceof WorkspaceDiagramIntentProviderContext && !Boolean.FALSE.equals(this.supportsPath((workspaceContext = (WorkspaceDiagramIntentProviderContext)context).getPath()))) {
            return this.getDiagramInfos(workspaceContext);
        }
        return null;
    }

    protected Collection<? extends DiagramIntent> getDiagramInfos(WorkbenchPartDiagramIntentProviderContext context) {
        return null;
    }

    protected Collection<? extends DiagramIntent> getDiagramInfos(WorkspaceDiagramIntentProviderContext context) {
        return null;
    }
}

