/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.Collection;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.text.AbstractDiagramIntentProvider;
import net.sourceforge.plantuml.text.TextDiagramIntentHelper;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.ResourceInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractTextDiagramIntentProvider
extends AbstractDiagramIntentProvider {
    private TextDiagramIntentHelper textDiagramIntentHelper = null;

    public AbstractTextDiagramIntentProvider() {
        this.setEditorType(ITextEditor.class);
    }

    @Override
    public Boolean supportsSelection(ISelection selection) {
        return selection instanceof ITextSelection;
    }

    protected String getStartPlantUmlRegex() {
        return "@startuml";
    }

    protected String getEndPlantUmlRegex() {
        return "@enduml";
    }

    public TextDiagramIntentHelper getTextDiagramIntentHelper() {
        if (this.textDiagramIntentHelper == null) {
            this.textDiagramIntentHelper = new TextDiagramIntentHelper(this.getStartPlantUml(), this.getStartPlantUmlRegex(), this.getEndPlantUml(), this.getEndPlantUmlRegex());
        }
        return this.textDiagramIntentHelper;
    }

    @Override
    protected Collection<? extends DiagramIntent> getDiagramInfos(WorkbenchPartDiagramIntentProviderContext context) {
        ITextEditor textEditor = this.getWorkbenchPart(context.getWorkbenchPart(), ITextEditor.class);
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)((IEditorPart)context.getWorkbenchPart()).getEditorInput());
        ISelection selection = context.getSelection();
        int selectionStart = ((ITextSelection)(selection != null ? selection : textEditor.getSelectionProvider().getSelection())).getOffset();
        ResourceInfo resourceInfo = new ResourceInfo();
        if (context.getPath() != null) {
            resourceInfo.setOriginalPath(context.getPath().toString());
        }
        return this.getTextDiagramIntentHelper().getDiagramInfos(document, selectionStart, resourceInfo);
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    protected String getDiagramText(StringBuilder lines) {
        return this.getTextDiagramIntentHelper().getDiagramText(lines);
    }

    public String getDiagramText(IPath path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file != null && file.exists()) {
            return this.getTextDiagramIntentHelper().getDiagramText(file);
        }
        return null;
    }
}

