/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.regex.Pattern;
import net.sourceforge.plantuml.eclipse.DiagramIntentProviderInfo;
import net.sourceforge.plantuml.eclipse.DiagramIntentProviderRegistry;
import net.sourceforge.plantuml.eclipse.DiagramTextProviderProcessor;
import net.sourceforge.plantuml.text.TextEditorDiagramIntentProvider;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin
implements DiagramTextProviderProcessor {
    private static Activator plugin;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        net.sourceforge.plantuml.eclipse.Activator plantumlActivator = net.sourceforge.plantuml.eclipse.Activator.getDefault();
        plantumlActivator.addDiagramTextProviderProcessor((DiagramTextProviderProcessor)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public void processDiagramIntentProviders(DiagramIntentProviderRegistry registry) {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("net.sourceforge.plantuml.text.textDiagramProvider");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("textDiagramProvider".equals(name)) {
                    try {
                        String diagramSuffixRegex;
                        String diagramPrefix = ces.getAttribute("diagramPrefix");
                        String diagramSuffix = ces.getAttribute("diagramSuffix");
                        String fileExtensionsString = ces.getAttribute("fileExtensions");
                        String[] fileExtensions = fileExtensionsString != null ? fileExtensionsString.split("[, ]") : new String[]{};
                        TextEditorDiagramIntentProvider textDiagramIntentProvider = new TextEditorDiagramIntentProvider(diagramPrefix, diagramSuffix, fileExtensions);
                        String diagramPrefixRegex = ces.getAttribute("diagramPrefixRegex");
                        if (diagramPrefixRegex == null) {
                            diagramPrefixRegex = Pattern.quote(diagramPrefix);
                        }
                        if ((diagramSuffixRegex = ces.getAttribute("diagramSuffixRegex")) == null) {
                            diagramSuffixRegex = Pattern.quote(diagramSuffix);
                        }
                        textDiagramIntentProvider.setDiagramPrefixRegex(diagramPrefixRegex);
                        textDiagramIntentProvider.setDiagramSuffixRegex(diagramSuffixRegex);
                        int priority = 5;
                        DiagramIntentProviderInfo info = new DiagramIntentProviderInfo();
                        info.id = ces.getAttribute("id");
                        info.label = ces.getAttribute("label");
                        info.priority = 5;
                        registry.registerDiagramIntentProvider((DiagramIntentProvider)textDiagramIntentProvider, info);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }
}

