/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.text.AbstractDiagramIntent;
import net.sourceforge.plantuml.text.TextDiagramIntent;
import net.sourceforge.plantuml.util.ResourceInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;

public class TextDiagramIntentHelper {
    private final String prefix;
    private final String prefixRegex;
    private final String suffix;
    private final String suffixRegex;

    public TextDiagramIntentHelper(String prefix, String prefixRegex, String suffix, String suffixRegex) {
        this.prefix = prefix;
        this.prefixRegex = prefixRegex;
        this.suffix = suffix;
        this.suffixRegex = suffixRegex;
    }

    public Collection<TextDiagramIntent> getDiagramInfos(IDocument document, int selectionStart, ResourceInfo resourceInfo) {
        ArrayList<TextDiagramIntent> intents = new ArrayList<TextDiagramIntent>();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        int start = 0;
        while (start < document.getLength()) {
            try {
                IRegion regionEnd;
                IRegion regionStart = finder.find(start, this.prefixRegex, true, true, false, true);
                if (regionStart == null || (regionEnd = finder.find(regionStart.getOffset() + regionStart.getLength(), this.suffixRegex, true, true, false, true)) == null) break;
                TextDiagramIntent intent = new TextDiagramIntent(document, regionStart.getOffset() + regionStart.getLength(), this);
                if (resourceInfo != null) {
                    intent.setResourceInfo(new ResourceInfo(resourceInfo));
                }
                if (selectionStart >= 0 && selectionStart >= regionStart.getOffset() && selectionStart <= regionEnd.getOffset() + regionEnd.getLength()) {
                    intent.setPriority(AbstractDiagramIntent.SELECTED_PRIORITY);
                }
                intents.add(intent);
                start = regionEnd.getOffset() + regionEnd.getLength();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return intents;
    }

    public StringBuilder getDiagramTextLines(IDocument document, int selectionStart, Map<String, Object> markerAttributes) {
        boolean includeStart = this.prefix.startsWith("@");
        boolean includeEnd = this.suffix.startsWith("@");
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        try {
            int altSelectionStart;
            IRegion start = finder.find(selectionStart, this.prefixRegex, false, true, false, true);
            if (start == null && (start = finder.find(altSelectionStart = Math.min(selectionStart + this.prefix.length(), document.getLength()), this.prefixRegex, false, true, false, true)) == null) {
                altSelectionStart = Math.min(selectionStart + this.prefixRegex.length(), document.getLength());
                start = finder.find(altSelectionStart, this.prefixRegex, false, true, false, true);
            }
            if (start != null) {
                int startOffset = start.getOffset();
                int startLine = document.getLineOfOffset(startOffset + (includeStart ? 0 : start.getLength()));
                int startLinePos = document.getLineOffset(startLine);
                IRegion end = finder.find(startOffset + start.getLength(), this.suffixRegex, true, true, false, true);
                if (end != null && end.getOffset() >= selectionStart) {
                    int endOffset = end.getOffset() + end.getLength();
                    String linePrefix = document.get(startLinePos, Math.max(0, startOffset - startLinePos));
                    StringBuilder result = new StringBuilder();
                    int maxLine = Math.min(document.getLineOfOffset(endOffset) + (includeEnd ? 1 : 0), document.getNumberOfLines());
                    int lineNum = startLine + (includeStart ? 0 : 1);
                    while (lineNum < maxLine) {
                        String line = document.get(document.getLineOffset(lineNum), document.getLineLength(lineNum));
                        int pos1 = line.startsWith(linePrefix) ? linePrefix.length() : 0;
                        String lineEnd = document.getLineDelimiter(lineNum);
                        int pos2 = line.length() - (lineEnd != null ? lineEnd.length() : 0);
                        result.append(line, pos1, pos2);
                        result.append("\n");
                        ++lineNum;
                    }
                    if (markerAttributes != null) {
                        markerAttributes.put("charStart", start.getOffset());
                    }
                    return result;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public String getDiagramText(CharSequence lines) {
        return this.getDiagramText(new StringBuilder(lines.toString()));
    }

    public String getDiagramText(StringBuilder lines) {
        int prefixPos = lines.indexOf(this.prefix);
        int start = Math.max(prefixPos, 0);
        int suffixPos = lines.lastIndexOf(this.suffix);
        int end = suffixPos < 0 ? lines.length() : Math.min(suffixPos + this.suffix.length(), lines.length());
        String linePrefix = lines.substring(0, start).trim();
        StringBuilder result = new StringBuilder(lines.length());
        if (prefixPos < 0) {
            result.append("@startuml\n");
        }
        while (start < end) {
            String line;
            int lineEnd = lines.indexOf("\n", start);
            if (lineEnd > end) break;
            if (lineEnd < 0) {
                lineEnd = lines.length();
            }
            if ((line = lines.substring(start, lineEnd)).startsWith(linePrefix)) {
                line = line.substring(linePrefix.length());
            }
            result.append(line);
            result.append("\n");
            start = lineEnd + 1;
        }
        if (suffixPos < 0) {
            result.append("@enduml\n");
        }
        return result.toString();
    }

    public String getDiagramText(IFile file) {
        IMarker marker = PlantumlUtil.getPlantUmlMarker((IFile)file, (boolean)false);
        int startOffset = marker.getAttribute("charStart", 0);
        StringBuilder builder = null;
        try {
            Scanner scanner = new Scanner(file.getContents());
            while (scanner.hasNextLine()) {
                String nextLine = scanner.nextLine();
                if (builder == null) {
                    if (startOffset <= nextLine.length()) {
                        if (nextLine.indexOf(this.prefix, startOffset) >= 0) {
                            builder = new StringBuilder();
                        }
                        startOffset = 0;
                    } else {
                        startOffset = startOffset - nextLine.length() - 1;
                    }
                }
                if (builder == null) continue;
                builder.append(nextLine);
                builder.append("\n");
                if (nextLine.contains(this.suffix)) break;
            }
            scanner.close();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (builder != null) {
            return this.getDiagramText(builder);
        }
        return null;
    }

    public Iterator<ISelection> getDiagramText(IDocument document) {
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(document);
        int selectionStart = 0;
        ArrayList<1> selections = new ArrayList<1>();
        try {
            while (true) {
                IRegion start = finder.find(selectionStart, this.prefixRegex, true, true, false, true);
                IRegion end = finder.find(selectionStart, this.suffixRegex, true, true, false, true);
                if (start != null && end != null) {
                    int diagramStart = start.getOffset() + start.getLength() + 1;
                    int diagramLine = document.getLineOfOffset(diagramStart);
                    final String line = document.get(document.getLineOffset(diagramLine), document.getLineLength(diagramLine)).trim();
                    TextSelection selection = new TextSelection(start.getOffset() + start.getLength(), 0){

                        public String toString() {
                            return line;
                        }
                    };
                    selections.add(selection);
                    selectionStart = end.getOffset() + end.getLength() + 1;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return selections.iterator();
    }
}

