/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.text.AbstractTextDiagramIntentProvider;
import org.eclipse.core.runtime.IPath;

public class TextEditorDiagramIntentProvider
extends AbstractTextDiagramIntentProvider {
    private final String diagramPrefix;
    private String diagramPrefixRegex;
    private final String diagramSuffix;
    private String diagramSuffixRegex;
    private final Collection<String> fileExtensions = new ArrayList<String>();

    public TextEditorDiagramIntentProvider(String diagramPrefix, String diagramSuffix, String ... fileExtensions) {
        this.diagramPrefix = diagramPrefix;
        this.diagramSuffix = diagramSuffix;
        this.setFileExtensions(fileExtensions);
    }

    protected void setFileExtensions(String ... fileExtensions) {
        this.fileExtensions.addAll(Arrays.asList(fileExtensions));
    }

    @Override
    public Boolean supportsPath(IPath path) {
        if (this.fileExtensions != null && !this.fileExtensions.isEmpty() && !this.fileExtensions.contains(path.getFileExtension())) {
            return false;
        }
        return true;
    }

    public void setDiagramPrefixRegex(String diagramPrefixRegex) {
        this.diagramPrefixRegex = diagramPrefixRegex;
    }

    public void setDiagramSuffixRegex(String diagramSuffixRegex) {
        this.diagramSuffixRegex = diagramSuffixRegex;
    }

    @Override
    protected String getStartPlantUml() {
        return this.diagramPrefix;
    }

    @Override
    protected String getStartPlantUmlRegex() {
        return this.diagramPrefixRegex;
    }

    @Override
    protected String getEndPlantUml() {
        return this.diagramSuffix;
    }

    @Override
    protected String getEndPlantUmlRegex() {
        return this.diagramSuffixRegex;
    }
}

