/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.plantuml.eclipse.DiagramIntentProviderInfo;
import net.sourceforge.plantuml.eclipse.DiagramIntentProviderRegistry;
import net.sourceforge.plantuml.eclipse.DiagramTextProviderProcessor;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.PropertiesLoader;
import net.sourceforge.plantuml.preferences.DiagramIntentPreferencePage;
import net.sourceforge.plantuml.preferences.DiagramIntentProvidersPreferencePage;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import net.sourceforge.plantuml.util.DiagramTextIntentProvider;
import net.sourceforge.plantuml.util.DiagramTextPostProcessor;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements DiagramIntentProviderRegistry {
    public static final String PLUGIN_ID = "net.sourceforge.plantuml.eclipse";
    private static Activator plugin;
    private Collection<IResourceChangeListener> resourceListeners;
    private PropertiesLoader propertiesLoader;
    private List<DiagramIntentProvider> diagramIntentProviders = null;
    private Map<DiagramIntentProvider, DiagramIntentProviderInfo> diagramIntentProviderInfo = null;
    private final Collection<DiagramTextProviderProcessor> diagramTextProviderProcessors = new ArrayList<DiagramTextProviderProcessor>();
    public static final int DEFAULT_PRIORITY = 0;
    public static final int NORMAL_PRIORITY = 5;
    public static final int CUSTOM_PRIORITY = 10;
    private final Comparator<DiagramIntentProvider> priorityComparator = new Comparator<DiagramIntentProvider>(){

        @Override
        public int compare(DiagramIntentProvider dtp2, DiagramIntentProvider dtp1) {
            return ((DiagramIntentProviderInfo)((Activator)Activator.this).diagramIntentProviderInfo.get((Object)dtp1)).priority - ((DiagramIntentProviderInfo)((Activator)Activator.this).diagramIntentProviderInfo.get((Object)dtp2)).priority;
        }
    };
    private List<ILinkOpener> linkOpeners;
    private List<DiagramTextPostProcessor> diagramTextPostProcessors;
    private final Map<Class<?>, Properties> classProperties = new HashMap();
    private IPath basePropertiesPath = null;
    public static final String propertiesFileExtension = "properties";
    private final Map<Class<?>, String> classAliases = new HashMap();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IResourceChangeListener[] iResourceChangeListenerArray = new IResourceChangeListener[1];
        this.propertiesLoader = new PropertiesLoader();
        iResourceChangeListenerArray[0] = this.propertiesLoader;
        this.resourceListeners = Arrays.asList(iResourceChangeListenerArray);
        for (IResourceChangeListener resourceListener : this.resourceListeners) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 16);
        }
        this.updateBasePropertiesPath();
        this.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent changeEvent) {
                if (DiagramIntentPreferencePage.BASE_PROPERTIES_PATH_PREFERENCE.equals(changeEvent.getProperty())) {
                    Activator.this.updateBasePropertiesPath();
                }
            }
        });
    }

    private void updateBasePropertiesPath() {
        String path = this.getPreferenceStore().getString(DiagramIntentPreferencePage.BASE_PROPERTIES_PATH_PREFERENCE);
        this.setBasePropertiesPath((IPath)(path != null && path.length() > 0 ? new Path(path) : null));
    }

    public void stop(BundleContext context) throws Exception {
        for (IResourceChangeListener resourceListener : this.resourceListeners) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public boolean isEnabled(DiagramIntentProvider diagramIntentProvider) {
        String id;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        return !preferenceStore.getBoolean(DiagramIntentProvidersPreferencePage.getDiagramTextProviderDisablementKey(id = this.getDiagramIntentProviderId(diagramIntentProvider)));
    }

    public void addDiagramTextProviderProcessor(DiagramTextProviderProcessor diagramTextProviderProcessor) {
        if (this.diagramIntentProviders == null) {
            this.diagramTextProviderProcessors.add(diagramTextProviderProcessor);
        } else {
            diagramTextProviderProcessor.processDiagramIntentProviders(this);
        }
    }

    public DiagramIntentProvider[] getDiagramIntentProviders(Boolean enabled) {
        if (this.diagramIntentProviders == null) {
            this.diagramIntentProviders = new ArrayList<DiagramIntentProvider>();
            this.diagramIntentProviderInfo = new HashMap<DiagramIntentProvider, DiagramIntentProviderInfo>();
            this.processDiagramTextProviders();
            for (DiagramTextProviderProcessor diagramTextProviderProcessor : this.diagramTextProviderProcessors) {
                diagramTextProviderProcessor.processDiagramIntentProviders(this);
            }
            this.processDiagramIntentProviders();
        }
        List<DiagramIntentProvider> diagramIntentProviders = this.diagramIntentProviders;
        if (enabled != null) {
            diagramIntentProviders = new ArrayList<DiagramIntentProvider>(diagramIntentProviders);
            Iterator it = diagramIntentProviders.iterator();
            while (it.hasNext()) {
                if (enabled.booleanValue() == this.isEnabled((DiagramIntentProvider)it.next())) continue;
                it.remove();
            }
        }
        return diagramIntentProviders.toArray(new DiagramIntentProvider[diagramIntentProviders.size()]);
    }

    public String getDiagramIntentProviderId(DiagramIntentProvider diagramIntentProvider) {
        if (this.diagramIntentProviderInfo != null) {
            DiagramIntentProviderInfo info = this.diagramIntentProviderInfo.get(diagramIntentProvider);
            String id = info != null ? info.id : null;
            return id != null ? id : diagramIntentProvider.getClass().getName();
        }
        return null;
    }

    public String getDiagramIntentProviderLabel(DiagramIntentProvider diagramIntentProvider) {
        if (this.diagramIntentProviderInfo != null) {
            DiagramIntentProviderInfo info = this.diagramIntentProviderInfo.get(diagramIntentProvider);
            return info != null ? info.label : null;
        }
        return null;
    }

    public int getDiagramIntentProviderPriority(DiagramIntentProvider diagramIntentProvider) {
        if (this.diagramIntentProviderInfo != null) {
            DiagramIntentProviderInfo info = this.diagramIntentProviderInfo.get(diagramIntentProvider);
            return info != null ? info.priority : 5;
        }
        return 5;
    }

    private void processDiagramTextProviders() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".diagramTextProvider");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("diagramTextProvider".equals(name)) {
                    try {
                        DiagramTextProvider diagramTextProvider = (DiagramTextProvider)ces.createExecutableExtension("providerClass");
                        DiagramIntentProviderInfo info = this.getProviderInfo(ces);
                        this.registerDiagramIntentProvider(new DiagramTextIntentProvider(diagramTextProvider), info);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void processDiagramIntentProviders() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".diagramIntentProvider");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("diagramIntentProvider".equals(name)) {
                    try {
                        DiagramIntentProvider diagramIntentProvider = (DiagramIntentProvider)ces.createExecutableExtension("providerClass");
                        DiagramIntentProviderInfo info = this.getProviderInfo(ces);
                        this.registerDiagramIntentProvider(diagramIntentProvider, info);
                    }
                    catch (InvalidRegistryObjectException diagramIntentProvider) {
                    }
                    catch (CoreException e) {
                        System.err.println((Object)e);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private DiagramIntentProviderInfo getProviderInfo(IConfigurationElement ces) {
        String priorityValue = ces.getAttribute("priority");
        int priority = 5;
        if ("custom".equals(priorityValue)) {
            priority = 10;
        } else if ("normal".equals(priorityValue)) {
            priority = 5;
        } else if ("default".equals(priorityValue)) {
            priority = 0;
        } else {
            try {
                priority = Integer.valueOf(priorityValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        DiagramIntentProviderInfo info = new DiagramIntentProviderInfo();
        info.id = ces.getAttribute("id");
        info.label = ces.getAttribute("label");
        info.priority = priority;
        return info;
    }

    @Override
    public void registerDiagramIntentProvider(DiagramIntentProvider diagramIntentProvider, DiagramIntentProviderInfo info) {
        this.diagramIntentProviderInfo.put(diagramIntentProvider, info);
        int pos = 0;
        while (pos < this.diagramIntentProviders.size()) {
            if (this.priorityComparator.compare(diagramIntentProvider, this.diagramIntentProviders.get(pos)) < 0) break;
            ++pos;
        }
        this.diagramIntentProviders.add(pos, diagramIntentProvider);
    }

    public ILinkOpener[] getLinkOpeners() {
        if (this.linkOpeners == null) {
            this.linkOpeners = new ArrayList<ILinkOpener>();
            this.processLinkOpeners();
        }
        return this.linkOpeners.toArray(new ILinkOpener[this.linkOpeners.size()]);
    }

    private void processLinkOpeners() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".linkOpener");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("linkOpener".equals(name)) {
                    try {
                        ILinkOpener linkOpener = (ILinkOpener)ces.createExecutableExtension("linkOpenerClass");
                        this.linkOpeners.add(linkOpener);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    public DiagramTextPostProcessor[] getDiagramTextPostProcessors() {
        if (this.diagramTextPostProcessors == null) {
            this.diagramTextPostProcessors = new ArrayList<DiagramTextPostProcessor>();
            this.processDiagramTextPostProcessors();
        }
        return this.diagramTextPostProcessors.toArray(new DiagramTextPostProcessor[this.diagramTextPostProcessors.size()]);
    }

    private void processDiagramTextPostProcessors() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(String.valueOf(this.getBundle().getSymbolicName()) + ".diagramTextPostProcessor");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("diagramTextPostProcessor".equals(name)) {
                    try {
                        DiagramTextPostProcessor diagramTextPostProcessor = (DiagramTextPostProcessor)ces.createExecutableExtension("postProcessorClass");
                        this.diagramTextPostProcessors.add(diagramTextPostProcessor);
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    public void setBasePropertiesPath(IPath basePropertiesPath) {
        IPath oldPath = this.basePropertiesPath;
        this.basePropertiesPath = basePropertiesPath;
        if (!Objects.equals(oldPath, basePropertiesPath)) {
            this.classProperties.clear();
        }
    }

    public Properties getProperties(Class<?> clazz) {
        if (clazz == Object.class) {
            return null;
        }
        Properties props = this.classProperties.get(clazz);
        if (props == null) {
            Properties staticProps = new Properties(this.getProperties(clazz.getSuperclass()));
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream input = clazz.getResourceAsStream(String.valueOf(clazz.getSimpleName()) + "." + propertiesFileExtension);){
                    if (input != null) {
                        this.propertiesLoader.loadProperties(staticProps, input);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            props = new Properties(staticProps);
            this.registerPropertiesPath(props, clazz.getSimpleName());
            String classAlias = this.classAliases.get(clazz);
            if (classAlias != null) {
                props = new Properties(props);
                this.registerPropertiesPath(props, classAlias);
            }
            this.classProperties.put(clazz, props);
        }
        return props;
    }

    private void registerPropertiesPath(Properties props, String key) {
        IPath path = this.getPropertiesFullPath(key);
        if (path != null) {
            this.propertiesLoader.register(props, path);
        }
    }

    private IPath getPropertiesFullPath(String key) {
        return this.basePropertiesPath != null ? this.basePropertiesPath.append(key).addFileExtension(propertiesFileExtension) : this.basePropertiesPath;
    }
}

