/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.WorkspaceDiagramIntentProviderContext;
import net.sourceforge.plantuml.util.DiagramData;
import net.sourceforge.plantuml.util.DiagramImageData;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class PlantumlUtil {
    public static final String PLANTUML_MARKER = "plantumlmarker";
    public static final String ORIGINAL_PATH_ATTRIBUTE = "original";
    public static final String DIAGRAM_INTENT_PROVIDER_ID_ATTRIBUTE = "diagramIntentProviderId";
    public static final String DIAGRAM_SOURCE_ATTRIBUTE = "diagramSource";
    public static final String TARGET_PATH_ATTRIBUTE = "target";
    private static final String imageNumMarker = "#";

    public static void updateMarker(IFile file, String textDiagram, IPath target, boolean create, Map<String, Object> markerAttributes) {
        IMarker marker = PlantumlUtil.getPlantUmlMarker(file, create);
        if (marker != null) {
            if (target == null) {
                try {
                    Object targetAttribute = marker.getAttribute(TARGET_PATH_ATTRIBUTE);
                    if (targetAttribute instanceof String) {
                        target = new Path(String.valueOf(targetAttribute));
                    }
                }
                catch (CoreException targetAttribute) {
                    // empty catch block
                }
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            if (markerAttributes != null) {
                attributes.putAll(markerAttributes);
            }
            attributes.put(ORIGINAL_PATH_ATTRIBUTE, file.getFullPath().toString());
            attributes.put(DIAGRAM_SOURCE_ATTRIBUTE, textDiagram);
            attributes.put(TARGET_PATH_ATTRIBUTE, target != null ? target.toString() : null);
            try {
                marker.setAttributes(attributes);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public static IMarker getPlantUmlMarker(IFile file, boolean create) {
        IMarker marker = null;
        try {
            IMarker[] markers = file.findMarkers(PLANTUML_MARKER, false, 0);
            if (markers != null && markers.length == 1) {
                marker = markers[0];
            } else if (create) {
                marker = file.createMarker(PLANTUML_MARKER);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return marker;
    }

    public static IResourceChangeListener createResourceListener() {
        return new AutoSaveHelper();
    }

    public static void saveDiagramImage(DiagramImageData diagramImageData, IPath path, boolean b) throws Exception {
        Function<Integer, String> fileNameProvider = PlantumlUtil.getImageFileNameProvider(path.lastSegment());
        DiagramData diagram = diagramImageData.getDiagramData();
        if (fileNameProvider != null) {
            IPath folderPath = path.removeLastSegments(1);
            int imageCount = diagram.getImageCount();
            int i = 0;
            while (i < imageCount) {
                IPath imagePath = folderPath.append(fileNameProvider.apply(i));
                PlantumlUtil.saveDiagramImage(diagramImageData.getSourcePath(), diagram.getTextDiagram(), i, diagram.getImage(i, null), imagePath, true);
                ++i;
            }
        } else {
            PlantumlUtil.saveDiagramImage(diagramImageData.getSourcePath(), diagram.getTextDiagram(), diagramImageData.getImageNum(), diagramImageData.getImage(), path, true);
        }
    }

    public static void saveDiagramImage(IPath sourcePath, String textDiagram, ImageData image, IPath targetPath, boolean create) throws Exception {
        PlantumlUtil.saveDiagramImage(sourcePath, textDiagram, 0, image, targetPath, create);
    }

    private static void saveDiagramImage(IPath sourcePath, String textDiagram, int imageNum, ImageData image, IPath targetPath, boolean create) throws Exception {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(targetPath);
        if (file != null && (create || file.exists())) {
            IFile sourceFile;
            String ext = targetPath.getFileExtension();
            if ("svg".equals(ext)) {
                PlantumlUtil.createSvgFile(file, textDiagram, imageNum);
            } else if ("puml".equals(ext) || "plantuml".equals(ext)) {
                PlantumlUtil.saveImage(file, textDiagram.getBytes());
            } else {
                PlantumlUtil.createImageFile(file, ext, image);
            }
            if (sourcePath != null && (sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile(sourcePath)) != null && sourceFile.exists()) {
                PlantumlUtil.updateMarker(sourceFile, textDiagram, targetPath, false, null);
            }
        }
    }

    private static void createImageFile(IFile file, String format, ImageData imageData) throws Exception {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        int swtFormat = SWT.class.getField("IMAGE_" + format.toUpperCase()).getInt(null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(32768);
        loader.save((OutputStream)outputStream, swtFormat);
        PlantumlUtil.saveImage(file, outputStream.toByteArray());
    }

    private static void saveImage(IFile file, byte[] bytes) throws CoreException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        if (file.exists()) {
            file.setContents((InputStream)inputStream, 1, (IProgressMonitor)progressMonitor);
        } else {
            file.create((InputStream)inputStream, 1, (IProgressMonitor)progressMonitor);
        }
        file.setDerived(true, (IProgressMonitor)progressMonitor);
    }

    private static void createSvgFile(IFile file, String textDiagram, int imageNum) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(32768);
        SourceStringReader reader = new SourceStringReader(textDiagram);
        reader.outputImage((OutputStream)outputStream, imageNum, new FileFormatOption(FileFormat.SVG));
        PlantumlUtil.saveImage(file, outputStream.toByteArray());
    }

    public static Function<Integer, String> getImageFileNameProvider(String filePathName) {
        int pos = filePathName.indexOf(imageNumMarker);
        if (pos < 0) {
            return null;
        }
        String filePathNamePrefix = filePathName.substring(0, pos);
        String filePathNameSuffix = filePathName.substring(pos + imageNumMarker.length());
        return imageNum -> String.valueOf(filePathNamePrefix) + (imageNum + 1) + filePathNameSuffix;
    }

    private static class AutoSaveHelper
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private AutoSaveHelper() {
        }

        public void resourceChanged(IResourceChangeEvent changeEvent) {
            try {
                changeEvent.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IMarker marker;
            if (delta.getKind() != 4 || (delta.getFlags() & 0x100) == 0) {
                return true;
            }
            IResource resource = delta.getResource();
            if (resource instanceof IFile && (marker = PlantumlUtil.getPlantUmlMarker((IFile)resource, false)) != null) {
                Object target = marker.getAttribute(PlantumlUtil.TARGET_PATH_ATTRIBUTE);
                Object diagramIntentProviderId = marker.getAttribute(PlantumlUtil.DIAGRAM_INTENT_PROVIDER_ID_ATTRIBUTE);
                if (target != null) {
                    IPath path = resource.getFullPath();
                    WorkspaceDiagramIntentProviderContext intentProviderContext = new WorkspaceDiagramIntentProviderContext(path);
                    DiagramIntentProvider[] diagramIntentProviderArray = Activator.getDefault().getDiagramIntentProviders(null);
                    int n = diagramIntentProviderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Collection<? extends DiagramIntent> diagramInfos;
                        DiagramIntentProvider diagramIntentProvider = diagramIntentProviderArray[n2];
                        if ((diagramIntentProviderId == null || diagramIntentProviderId.toString().equals(Activator.getDefault().getDiagramIntentProviderId(diagramIntentProvider))) && (diagramInfos = diagramIntentProvider.getDiagramInfos(intentProviderContext)) != null) {
                            for (DiagramIntent diagramIntent : diagramInfos) {
                                String textDiagram = diagramIntent.getDiagramText();
                                if (textDiagram == null) continue;
                                DiagramData diagram = new DiagramData(textDiagram);
                                diagram.setOriginal(path);
                                try {
                                    PlantumlUtil.saveDiagramImage(path, textDiagram, diagram.getImage(), (IPath)new Path(target.toString()), false);
                                }
                                catch (Exception e) {
                                    System.err.println(e);
                                }
                                return false;
                            }
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }
    }
}

