/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PropertiesLoader
implements IResourceChangeListener,
IResourceDeltaVisitor {
    private final Map<IPath, Properties> pathProperties = new HashMap<IPath, Properties>();

    public void register(Properties properties, IPath path) {
        this.loadProperties(properties, (IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(path));
        this.pathProperties.put(path, properties);
    }

    public void resourceChanged(IResourceChangeEvent changeEvent) {
        try {
            changeEvent.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource;
        int kind = delta.getKind();
        if ((kind == 1 || kind == 4 && (delta.getFlags() & 0x100) != 0) && (resource = delta.getResource()) instanceof IFile) {
            Properties properties = this.pathProperties.get(resource.getFullPath());
            if (properties != null) {
                this.loadProperties(properties, resource);
            }
            return false;
        }
        return true;
    }

    public void loadProperties(Properties props, IResource resource) {
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream input = ((IFile)resource).getContents();){
                this.loadProperties(props, input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void loadProperties(Properties props, InputStream input) {
        try {
            if (input != null) {
                props.load(input);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

