/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.LocationDiagramIntentProviderContext;
import net.sourceforge.plantuml.eclipse.utils.PlantumlConstants;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.eclipse.views.DiagramViewStatusListener;
import net.sourceforge.plantuml.util.AbstractDiagramIntent;
import net.sourceforge.plantuml.util.AbstractProperties;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntentContext;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import net.sourceforge.plantuml.util.DiagramTextPostProcessor;
import net.sourceforge.plantuml.util.SimpleDiagramIntent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractDiagramSourceView
extends ViewPart {
    private String pinnedToId = null;
    private IEditorPart pinnedTo = null;
    private String initialDiagramSource = null;
    private Control parent;
    private IAction toggleLinkAction;
    private IAction pinToAction;
    private IAction spawnAction;
    private boolean visible = false;
    private final IPartListener2 partListener = new PartListener();
    private final DiagramTextChangedListener diagramTextChangedListener = new DiagramTextChangedListener();
    private IWorkbenchPart currentPart;
    private Collection<DiagramViewStatusListener> diagramViewListeners = new ArrayList<DiagramViewStatusListener>();
    private ViewStatus viewStatus;
    private Job currentJob = null;

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("pinnedTo", this.pinnedTo != null ? this.getEditorInputId(this.pinnedTo.getEditorInput()) : null);
        memento.putString("initialDiagramSource", this.getDiagramText());
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.pinnedToId = memento.getString("pinnedTo");
            this.initialDiagramSource = memento.getString("initialDiagramSource");
        }
    }

    public boolean isLinkedToActivePart() {
        return true;
    }

    public boolean isLinkingActive() {
        return this.isLinkedToActivePart() && this.toggleLinkAction == null || this.toggleLinkAction.isChecked();
    }

    protected void asyncExec(Runnable runnable) {
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.getDisplay().asyncExec(runnable);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        if (this.isLinkedToActivePart()) {
            this.registerListeners();
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDiagramSourceView.this.pinnedTo != null || AbstractDiagramSourceView.this.initialDiagramSource == null) {
                        AbstractDiagramSourceView.this.updateDiagramText(true, (IWorkbenchPart)AbstractDiagramSourceView.this.pinnedTo, null);
                    } else if (AbstractDiagramSourceView.this.initialDiagramSource != null) {
                        AbstractDiagramSourceView.this.updateDiagramText(new SimpleDiagramIntent(AbstractDiagramSourceView.this.initialDiagramSource));
                    }
                }
            });
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    protected boolean isValidControl(Control control) {
        return control != null && !control.isDisposed();
    }

    protected void contributeToActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addViewActions((IContributionManager)toolBarManager);
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager editorSelectionActionMenu = new MenuManager("Diagrams");
        editorSelectionActionMenu.add((IAction)new Action(){});
        editorSelectionActionMenu.setRemoveAllWhenShown(true);
        editorSelectionActionMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                for (ActionContributionItem actionContributionItem : AbstractDiagramSourceView.this.getEditorSelectionActions(menu)) {
                    menu.add((IContributionItem)actionContributionItem);
                }
            }
        });
        menu.add((IContributionItem)editorSelectionActionMenu);
    }

    protected void makeActions() {
        this.pinToAction = new Action(){

            public boolean isEnabled() {
                return AbstractDiagramSourceView.this.isLinkedToActivePart();
            }

            public void run() {
                AbstractDiagramSourceView.this.pinnedTo = this.isChecked() && AbstractDiagramSourceView.this.currentPart instanceof IEditorPart ? (IEditorPart)AbstractDiagramSourceView.this.currentPart : null;
                if (AbstractDiagramSourceView.this.pinnedTo != null) {
                    this.setToolTipText("Pinned to " + AbstractDiagramSourceView.this.getEditorInputId(AbstractDiagramSourceView.this.pinnedTo.getEditorInput()));
                } else {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                    this.setToolTipText("Pin view to editor");
                }
            }
        };
        this.pinToAction.setToolTipText("Pin view to editor");
        this.pinToAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/pin.png"));
        this.pinToAction.setChecked(this.pinnedTo != null || this.pinnedToId != null);
        this.spawnAction = new Action(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String id = AbstractDiagramSourceView.this.getViewSite().getId();
                try {
                    page.showView(id, String.valueOf(id) + "-" + System.currentTimeMillis(), 1);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        };
        this.spawnAction.setToolTipText("Open another view");
        this.spawnAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/spawn.png"));
        this.toggleLinkAction = new Action(){

            public void run() {
                if (this.isChecked()) {
                    AbstractDiagramSourceView.this.updateDiagramText(true, null, null);
                }
            }
        };
        this.toggleLinkAction.setToolTipText("Link with editor");
        this.toggleLinkAction.setImageDescriptor(ImageDescriptor.createFromFile(PlantumlConstants.class, (String)"/icons/link.gif"));
        this.toggleLinkAction.setChecked(true);
    }

    protected void addActions(IContributionManager manager, IAction ... actions) {
        if (!manager.isEmpty()) {
            manager.add((IContributionItem)new Separator());
        }
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            manager.add(action);
            ++n2;
        }
    }

    protected void addViewActions(IContributionManager toolBarManager) {
        this.addActions(toolBarManager, this.spawnAction, this.pinToAction, this.toggleLinkAction);
    }

    protected String getEditorInputId(IEditorInput editorInput) {
        if (editorInput instanceof IStorageEditorInput) {
            IPath path = null;
            try {
                path = ((IStorageEditorInput)editorInput).getStorage().getFullPath();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (path != null) {
                return path.toString();
            }
        }
        if (editorInput instanceof IPathEditorInput) {
            return ((IPathEditorInput)editorInput).getPath().toString();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI().toString();
        }
        return editorInput.getName();
    }

    protected boolean acceptPart(IWorkbenchPart part) {
        if (this.pinnedTo == null && this.pinnedToId == null) {
            return true;
        }
        if (this.pinnedTo != null && this.pinnedTo == part) {
            return true;
        }
        if (part instanceof IEditorPart && this.pinnedToId != null && this.acceptEditorInput(this.pinnedToId, ((IEditorPart)part).getEditorInput())) {
            this.pinnedTo = (IEditorPart)part;
            this.pinnedToId = null;
            return true;
        }
        return false;
    }

    protected boolean acceptEditorInput(String inputId, IEditorInput editorInput) {
        return this.pinnedToId.equals(this.getEditorInputId(editorInput));
    }

    protected void registerListeners() {
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
    }

    public void dispose() {
        if (this.currentPart != null) {
            this.currentPart.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.diagramTextChangedListener);
    }

    protected abstract void updateDiagramText(String var1, DiagramIntent var2, IProgressMonitor var3);

    public abstract String getDiagramText();

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected boolean isPlantUmlView(String partId) {
        return partId.startsWith("net.sourceforge.plantuml.eclipse.views.");
    }

    protected boolean isPlantUmlView(IWorkbenchPartReference partRef) {
        return this.isPlantUmlView(partRef.getId());
    }

    protected boolean isThisView(IWorkbenchPartReference partRef) {
        return partRef.getId().equals(this.getSite().getId());
    }

    private void handlePartChange(IWorkbenchPart part) {
        if (this.currentPart != null) {
            this.currentPart.removePropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
        this.currentPart = part;
        if (this.currentPart != null) {
            this.currentPart.addPropertyListener((IPropertyListener)this.diagramTextChangedListener);
        }
    }

    protected Collection<ActionContributionItem> getEditorSelectionActions(IMenuManager menu) {
        ArrayList<ActionContributionItem> actions = new ArrayList<ActionContributionItem>();
        DiagramIntentProvider[] diagramIntentProviders = Activator.getDefault().getDiagramIntentProviders(true);
        IEditorPart part = this.pinnedTo != null ? this.pinnedTo : this.getSite().getPage().getActiveEditor();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        WorkbenchPartDiagramIntentProviderContext partContext = new WorkbenchPartDiagramIntentProviderContext((IWorkbenchPart)part, selectionProvider != null ? selectionProvider.getSelection() : null);
        DiagramIntentProvider[] diagramIntentProviderArray = diagramIntentProviders;
        int n = diagramIntentProviders.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramIntentProvider diagramIntentProvider = diagramIntentProviderArray[n2];
            Collection<? extends DiagramIntent> diagramInfos = diagramIntentProvider.getDiagramInfos(partContext);
            if (diagramInfos != null) {
                String diagramIntentProviderLabel = Activator.getDefault().getDiagramIntentProviderLabel(diagramIntentProvider);
                int count = 0;
                for (DiagramIntent diagramIntent : diagramInfos) {
                    String label = diagramIntentProviderLabel;
                    if (diagramInfos.size() > 1) {
                        label = String.valueOf(label) + " " + (count + 1);
                    }
                    ActionContributionItem action = new ActionContributionItem((IAction)this.createEditorSelectionAction(diagramIntent, label));
                    actions.add(action);
                    ++count;
                }
            }
            ++n2;
        }
        return actions;
    }

    private Action createEditorSelectionAction(final DiagramIntent diagramIntent, String label) {
        return new Action(label){

            public void run() {
                AbstractDiagramSourceView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDiagramSourceView.this.updateDiagramText(diagramIntent);
                    }
                });
            }
        };
    }

    public void updateDiagramText() {
        this.updateDiagramText(true, null, null);
    }

    protected void updateDiagramText(boolean force, IWorkbenchPart part, ISelection selection) {
        IWorkbenchPart activePart;
        Object object = part != null ? part : (activePart = this.isLinkedToActivePart() ? this.getSite().getPage().getActivePart() : null);
        if ((force || activePart != this.currentPart) && (activePart == null || this.acceptPart(activePart))) {
            this.handlePartChange(activePart);
            if (activePart != null) {
                ISelectionProvider selectionProvider;
                if (selection == null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null) {
                    selection = selectionProvider.getSelection();
                }
                if (this.updateDiagramText(activePart, selection)) {
                    return;
                }
            }
            this.updateDiagramText(null, null, null);
        }
    }

    public void addDiagramViewListener(DiagramViewStatusListener listener) {
        if (this.diagramViewListeners == null) {
            this.diagramViewListeners = new ArrayList<DiagramViewStatusListener>();
        }
        this.diagramViewListeners.add(listener);
    }

    public void removeDiagramViewListener(DiagramViewStatusListener listener) {
        if (this.diagramViewListeners != null) {
            this.diagramViewListeners.remove(listener);
        }
    }

    protected ViewStatus getViewStatus() {
        return this.viewStatus;
    }

    protected void setDiagramViewStatus(ViewStatus status, Object diagram) {
        this.fireDiagramViewStatusChanged(status, diagram);
    }

    private void fireDiagramViewStatusChanged(ViewStatus status, Object diagram) {
        if (this.diagramViewListeners != null) {
            for (DiagramViewStatusListener listener : this.diagramViewListeners) {
                listener.diagramViewStatusChanged(this, status, diagram);
            }
        }
    }

    private boolean updateDiagramText(IWorkbenchPart activePart, ISelection selection) {
        if (activePart != null) {
            WorkbenchPartDiagramIntentProviderContext context = new WorkbenchPartDiagramIntentProviderContext(activePart, selection);
            DiagramIntent bestIntent = null;
            int bestPriority = AbstractDiagramIntent.DEFAULT_PRIORITY - 1;
            int lastProviderPriority = 0;
            DiagramIntentProvider[] diagramIntentProviderArray = Activator.getDefault().getDiagramIntentProviders(true);
            int n = diagramIntentProviderArray.length;
            int n2 = 0;
            while (n2 < n) {
                DiagramIntentProvider diagramIntentProvider = diagramIntentProviderArray[n2];
                int providerPriority = Activator.getDefault().getDiagramIntentProviderPriority(diagramIntentProvider);
                if (providerPriority < lastProviderPriority && bestIntent != null) break;
                Collection<? extends DiagramIntent> diagramInfos = diagramIntentProvider.getDiagramInfos(context);
                if (diagramInfos != null && !diagramInfos.isEmpty()) {
                    for (DiagramIntent diagramIntent : diagramInfos) {
                        if (diagramIntent.getPriority() <= bestPriority) continue;
                        bestIntent = diagramIntent;
                        bestPriority = diagramIntent.getPriority();
                        if (!(bestIntent instanceof AbstractDiagramIntent)) continue;
                        this.setDiagramContextProperties(((AbstractDiagramIntent)bestIntent).getContextProperties(), diagramIntentProvider);
                    }
                }
                lastProviderPriority = providerPriority;
                ++n2;
            }
            if (bestIntent != null) {
                this.setDiagramViewStatus(ViewStatus.DIAGRAM_INTENT, bestIntent);
                if (bestIntent instanceof AbstractDiagramIntent) {
                    this.setDiagramContextProperties(((AbstractDiagramIntent)bestIntent).getContextProperties(), context);
                }
                this.updateDiagramText(bestIntent);
                return true;
            }
        }
        return false;
    }

    private void setDiagramContextProperties(AbstractProperties diagramContextProperties, DiagramIntentProvider diagramIntentProvider) {
        diagramContextProperties.setProperty("diagramIntentProviderId", Activator.getDefault().getDiagramIntentProviderId(diagramIntentProvider));
    }

    private void setDiagramContextProperties(AbstractProperties diagramContextProperties, DiagramIntentContext context) {
        IPath path;
        if (context instanceof WorkbenchPartDiagramIntentProviderContext) {
            diagramContextProperties.setProperty("workbenchPartId", ((WorkbenchPartDiagramIntentProviderContext)context).getWorkbenchPart().getSite().getId());
        }
        if (context instanceof LocationDiagramIntentProviderContext && (path = ((LocationDiagramIntentProviderContext)context).getPath()) != null) {
            diagramContextProperties.setProperty("path", path.toString());
        }
    }

    protected synchronized void updateDiagramText(final DiagramIntent diagramIntent) {
        if (this.currentJob != null) {
            this.currentJob.cancel();
        }
        this.currentJob = new Job("Generate diagram"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String diagramText = diagramIntent.getDiagramText();
                    if (!(monitor != null && monitor.isCanceled() || diagramText == null)) {
                        diagramText = AbstractDiagramSourceView.this.ensureDiagram(diagramText);
                        if (diagramIntent instanceof AbstractDiagramIntent) {
                            diagramText = AbstractDiagramSourceView.this.postProcessDiagramText(diagramText, (AbstractDiagramIntent)diagramIntent);
                        }
                        AbstractDiagramSourceView.this.setDiagramViewStatus(ViewStatus.DIAGRAM_TEXT, diagramText);
                        AbstractDiagramSourceView.this.updateDiagramText(diagramText, diagramIntent, monitor);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                AbstractDiagramSourceView.this.currentJob = null;
                return monitor != null && monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        this.currentJob.schedule();
    }

    private String postProcessDiagramText(String diagramText, AbstractDiagramIntent<?> diagramIntent) {
        DiagramTextPostProcessor[] diagramTextPostProcessorArray = Activator.getDefault().getDiagramTextPostProcessors();
        int n = diagramTextPostProcessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramTextPostProcessor postProcessor = diagramTextPostProcessorArray[n2];
            String altDiagramText = postProcessor.getDiagramText(diagramText, diagramIntent);
            if (altDiagramText != null) {
                diagramText = altDiagramText;
            }
            ++n2;
        }
        return diagramText;
    }

    protected String ensureDiagram(String diagramText) {
        if (!diagramText.startsWith("@")) {
            diagramText = "@startuml\n" + diagramText;
            String suffix = "@enduml";
            if (!diagramText.endsWith("\n")) {
                suffix = "\n" + suffix;
            }
            diagramText = String.valueOf(diagramText) + suffix;
        }
        return diagramText;
    }

    private class DiagramTextChangedListener
    implements IPropertyListener,
    ISelectionListener,
    ISelectionChangedListener {
        private DiagramTextChangedListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source == AbstractDiagramSourceView.this.currentPart && propId == 257 && AbstractDiagramSourceView.this.currentPart instanceof IEditorPart && !((IEditorPart)AbstractDiagramSourceView.this.currentPart).isDirty()) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentPart, null);
            }
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == AbstractDiagramSourceView.this.currentPart) {
                this.diagramChanged(AbstractDiagramSourceView.this.currentPart, selection);
            }
        }

        protected void diagramChanged(IWorkbenchPart editor, ISelection selection) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(true, editor, selection);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if ((!(event.getSource() instanceof DiagramIntentProvider) || Activator.getDefault().isEnabled((DiagramIntentProvider)event.getSource())) && (selection = event.getSelection()) instanceof IStructuredSelection) {
                final Object o = ((IStructuredSelection)selection).getFirstElement();
                AbstractDiagramSourceView.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDiagramSourceView.this.updateDiagramText(new SimpleDiagramIntent(String.valueOf(o)));
                    }
                });
            }
        }
    }

    private class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        protected void updateDiagramText(IWorkbenchPart part) {
            if (AbstractDiagramSourceView.this.isLinkingActive()) {
                AbstractDiagramSourceView.this.updateDiagramText(false, part, null);
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (!AbstractDiagramSourceView.this.isPlantUmlView(partRef)) {
                this.updateDiagramText(partRef.getPart(true));
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (AbstractDiagramSourceView.this.isThisView(partRef)) {
                AbstractDiagramSourceView.this.setVisible(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (AbstractDiagramSourceView.this.isThisView(partRef)) {
                AbstractDiagramSourceView.this.setVisible(false);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }
    }

    public static enum ViewStatus {
        DIAGRAM_INTENT,
        DIAGRAM_TEXT,
        DIAGRAM_VIEW_TEXT,
        DIAGRAM_VIEW_DATA,
        DIAGRAM_VIEW;

    }
}

