/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.imagecontrol.ILinkSupport;
import net.sourceforge.plantuml.eclipse.utils.ILinkOpener;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.eclipse.views.AbstractDiagramSourceView;
import net.sourceforge.plantuml.util.AbstractDiagramIntent;
import net.sourceforge.plantuml.util.DiagramData;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.ResourceInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractPlantUmlView
extends AbstractDiagramSourceView
implements ILinkSupport {
    protected Composite composite;
    protected DiagramData diagramData = null;
    protected Runnable layoutComposite = () -> {
        if (!this.composite.isDisposed()) {
            this.composite.layout();
        }
    };
    private Collection<ILinkOpener> linkOpeners = null;

    @Override
    public void createPartControl(Composite parent) {
        this.composite = parent;
        this.createDiagramControl(parent);
        super.createPartControl(parent);
    }

    protected abstract void createDiagramControl(Composite var1);

    protected boolean shouldUpdateView(DiagramData diagramData) {
        return this.diagramData == null || this.diagramData == diagramData;
    }

    @Override
    public String getDiagramText() {
        return this.diagramData != null ? this.diagramData.getTextDiagram() : null;
    }

    @Override
    protected void updateDiagramText(String textDiagram, DiagramIntent diagramIntent, IProgressMonitor monitor) {
        if (this.isVisible() && textDiagram != null && (this.diagramData == null || !textDiagram.equals(this.diagramData.getTextDiagram()))) {
            ResourceInfo resourceInfo;
            this.diagramData = null;
            DiagramData diagramData = new DiagramData(textDiagram);
            this.setDiagramViewStatus(AbstractDiagramSourceView.ViewStatus.DIAGRAM_VIEW_TEXT, textDiagram);
            if (diagramIntent instanceof AbstractDiagramIntent && (resourceInfo = ((AbstractDiagramIntent)diagramIntent).getResourceInfo()) != null) {
                if (resourceInfo.getOriginalPath() != null) {
                    diagramData.setOriginal((IPath)new Path(resourceInfo.getOriginalPath()));
                }
                diagramData.setMarkerAttributes(resourceInfo.getMarkerAttributes());
            }
            this.updateDiagram(diagramData, monitor);
            if (monitor == null || !monitor.isCanceled()) {
                this.diagramData = diagramData;
                this.updateDiagramMarkers();
            }
        }
    }

    protected void updateDiagram(IProgressMonitor monitor) {
        if (this.diagramData != null) {
            this.updateDiagram(this.diagramData, monitor);
        }
    }

    protected abstract void updateDiagram(DiagramData var1, IProgressMonitor var2);

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.diagramData != null) {
            this.updateDiagramText(true, null, null);
        }
    }

    protected void updateDiagramMarkers() {
        IFile file;
        if (this.diagramData.getOriginal() != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.diagramData.getOriginal())) != null && file.exists()) {
            PlantumlUtil.updateMarker(file, this.diagramData.getTextDiagram(), null, true, this.diagramData.getMarkerAttributes());
        }
    }

    private Collection<ILinkOpener> getLinkOpeners() {
        if (this.linkOpeners == null) {
            this.linkOpeners = Arrays.asList(Activator.getDefault().getLinkOpeners());
        }
        return this.linkOpeners;
    }

    public void openLink(Object link) {
        LinkData linkData = null;
        if (link instanceof LinkData) {
            linkData = (LinkData)link;
        } else if (link != null) {
            try {
                URI uri = new URI(link.toString());
                linkData = new LinkData();
                linkData.href = uri.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (linkData != null) {
            this.openLink(linkData);
        }
    }

    protected boolean openLink(LinkData linkData) {
        ILinkOpener linkOpener = this.findBestLinkOpener(linkData, 0);
        if (linkOpener != null) {
            linkOpener.openLink(linkData);
            return true;
        }
        return false;
    }

    private ILinkOpener findBestLinkOpener(LinkData link, int minSupport) {
        int bestSupport = -1;
        ILinkOpener best = null;
        for (ILinkOpener linkOpener : this.getLinkOpeners()) {
            int support = -1;
            try {
                support = linkOpener.supportsLink(link);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (support < bestSupport) continue;
            bestSupport = support;
            best = linkOpener;
        }
        return bestSupport >= minSupport ? best : null;
    }
}

