/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views;

import java.util.function.Supplier;
import net.sourceforge.plantuml.eclipse.imagecontrol.ILinkSupport;
import net.sourceforge.plantuml.eclipse.imagecontrol.ImageControl;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.MenuSupport;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomAction;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomFitAction;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ZoomResetAction;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.eclipse.views.AbstractDiagramSourceView;
import net.sourceforge.plantuml.eclipse.views.AbstractPlantUmlView;
import net.sourceforge.plantuml.eclipse.views.DiagramImageControl;
import net.sourceforge.plantuml.eclipse.views.actions.CopyAction;
import net.sourceforge.plantuml.eclipse.views.actions.CopyAsciiAction;
import net.sourceforge.plantuml.eclipse.views.actions.CopySourceAction;
import net.sourceforge.plantuml.eclipse.views.actions.ExportAction;
import net.sourceforge.plantuml.eclipse.views.actions.PrintAction;
import net.sourceforge.plantuml.eclipse.views.actions.SaveAction;
import net.sourceforge.plantuml.util.DiagramData;
import net.sourceforge.plantuml.util.DiagramImageData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class PlantUmlView
extends AbstractPlantUmlView
implements ILinkSupport {
    private DiagramImageControl[] imageControls;
    private TabFolder tabFolder = null;
    private MenuSupport menuSupport;
    private final Listener mouseWheelListener = new Listener(){

        public void handleEvent(Event e) {
            if ((e.stateMask & 0x40000) != 0) {
                if (e.count > 0) {
                    PlantUmlView.this.zoomInAction.run();
                } else {
                    PlantUmlView.this.zoomOutAction.run();
                }
            }
        }
    };
    private final KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.character) {
                case '+': {
                    PlantUmlView.this.zoomInAction.run();
                    break;
                }
                case '-': {
                    PlantUmlView.this.zoomOutAction.run();
                    break;
                }
            }
        }
    };
    private IAction zoomInAction;
    private IAction zoomOutAction;
    private IAction fitCanvasAction;
    private IAction showOriginalAction;
    private final float ZOOMIN_RATE = 1.1f;
    private final float ZOOMOUT_RATE = 0.9f;

    @Override
    protected void createDiagramControl(Composite parent) {
        this.ensureImageControls(0);
        this.menuSupport = new MenuSupport();
        this.addCanvasActions();
    }

    private DiagramImageControl createImageControl(Composite parent) {
        DiagramImageControl imageControl = new DiagramImageControl(parent);
        imageControl.addLinkSupport(this);
        this.menuSupport.addImageControl((Control)imageControl);
        imageControl.addListener(37, this.mouseWheelListener);
        imageControl.addKeyListener((KeyListener)this.keyListener);
        return imageControl;
    }

    private synchronized void ensureImageControls(int count) {
        if (this.imageControls != null && this.imageControls.length == count) {
            return;
        }
        if (this.tabFolder != null && count <= 1) {
            this.tabFolder.dispose();
            this.tabFolder = null;
        } else if (this.imageControls != null) {
            int retained = count > 1 && this.tabFolder == null ? 0 : count;
            int i = this.imageControls.length - 1;
            while (i >= retained) {
                if (this.tabFolder != null) {
                    this.tabFolder.getItem(i).dispose();
                }
                this.imageControls[i].dispose();
                --i;
            }
        } else {
            this.imageControls = new DiagramImageControl[count];
        }
        if (this.imageControls.length != count) {
            DiagramImageControl[] newImageControls = new DiagramImageControl[count];
            System.arraycopy(this.imageControls, 0, newImageControls, 0, Math.min(this.imageControls.length, newImageControls.length));
            this.imageControls = newImageControls;
        }
        if (count > 1 && this.tabFolder == null) {
            this.tabFolder = new TabFolder(this.composite, 1024);
        }
        int i = 0;
        while (i < this.imageControls.length) {
            if (this.imageControls[i] == null || this.imageControls[i].isDisposed()) {
                this.imageControls[i] = this.createImageControl((Composite)(this.tabFolder != null ? this.tabFolder : this.composite));
                if (this.tabFolder != null) {
                    TabItem tab = new TabItem(this.tabFolder, 0);
                    tab.setText(String.valueOf(i + 1));
                    tab.setControl((Control)this.imageControls[i]);
                }
            }
            ++i;
        }
    }

    private void addCanvasActions() {
        Supplier<DiagramData> diagramDataSupplier = () -> this.diagramData;
        Supplier<DiagramImageData> diagramImageDataSupplier = () -> this.getCurrentImageControl().getDiagramImageData();
        Display display = this.composite.getDisplay();
        this.menuSupport.addMenuAction((Action)new CopyAction(diagramImageDataSupplier, display));
        this.menuSupport.addMenuAction((Action)new CopySourceAction(diagramDataSupplier, display));
        this.menuSupport.addMenuAction((Action)new CopyAsciiAction(diagramImageDataSupplier, display));
        Shell shell = this.composite.getShell();
        this.menuSupport.addMenuAction((Action)new SaveAction(diagramImageDataSupplier, shell));
        this.menuSupport.addMenuAction((Action)new ExportAction(diagramImageDataSupplier, shell));
        this.menuSupport.addMenuAction((Action)new PrintAction(diagramImageDataSupplier, shell));
    }

    protected DiagramImageControl getCurrentImageControl() {
        int imageNum = 0;
        if (this.tabFolder != null) {
            imageNum = this.tabFolder.getSelectionIndex();
        }
        return this.imageControls.length > imageNum ? this.imageControls[imageNum] : null;
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        Supplier<ImageControl> imageControlSupplier = () -> this.getCurrentImageControl();
        this.zoomInAction = new ZoomAction(imageControlSupplier, 1.1f);
        this.zoomInAction.setToolTipText("Zoom in");
        this.zoomOutAction = new ZoomAction(imageControlSupplier, 0.9f);
        this.zoomOutAction.setToolTipText("Zoom out");
        this.fitCanvasAction = new ZoomFitAction(imageControlSupplier);
        this.fitCanvasAction.setToolTipText("Fit to canvas");
        this.showOriginalAction = new ZoomResetAction(imageControlSupplier);
        this.showOriginalAction.setToolTipText("Show original");
    }

    @Override
    protected void contributeToActionBars() {
        super.contributeToActionBars();
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addZoomActions((IContributionManager)toolBarManager);
    }

    protected void addZoomActions(IContributionManager toolBarManager) {
        this.addActions(toolBarManager, this.zoomInAction, this.zoomOutAction, this.fitCanvasAction, this.showOriginalAction);
    }

    public void setFocus() {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        (imageControl != null ? imageControl : this.composite).setFocus();
    }

    @Override
    protected void updateDiagram(DiagramData diagramData, IProgressMonitor monitor) {
        DiagramImageData[] diagramImageDatas = new DiagramImageData[diagramData.getImageCount()];
        int imageNum = 0;
        while (imageNum < diagramImageDatas.length) {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            DiagramImageData diagramImageData = new DiagramImageData(diagramData, imageNum, null);
            diagramImageData.getImage();
            diagramImageDatas[imageNum] = diagramImageData;
            ++imageNum;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.setDiagramViewStatus(AbstractDiagramSourceView.ViewStatus.DIAGRAM_VIEW_DATA, diagramImageDatas);
        this.asyncExec(() -> {
            if (this.shouldUpdateView(diagramData)) {
                this.ensureImageControls(diagramImageDatas.length);
                int imageNum = 0;
                while (imageNum < this.imageControls.length) {
                    if (this.imageControls[imageNum] != null && !this.imageControls[imageNum].isDisposed()) {
                        this.imageControls[imageNum].updateDiagramImage(diagramImageDatas[imageNum]);
                    }
                    ++imageNum;
                }
                this.setDiagramViewStatus(AbstractDiagramSourceView.ViewStatus.DIAGRAM_VIEW, diagramImageDatas);
            }
        });
        this.asyncExec(this.layoutComposite);
    }

    public Object getLink(int x, int y) {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        if (imageControl != null) {
            for (LinkData linkData : imageControl.getDiagramImageData().getLinks()) {
                if (linkData.rect == null || !linkData.rect.contains(x, y)) continue;
                return linkData.title != null ? linkData.title : linkData.href;
            }
        }
        return null;
    }

    @Override
    public void openLink(Object href) {
        DiagramImageControl imageControl = this.getCurrentImageControl();
        if (imageControl != null) {
            for (LinkData linkData : imageControl.getDiagramImageData().getLinks()) {
                if (linkData.title != href && linkData.href != href || !this.openLink(linkData)) continue;
                return;
            }
        }
    }
}

