/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views.actions;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.eclipse.views.actions.DiagramImageAction;
import net.sourceforge.plantuml.util.DiagramImageData;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyAsciiAction
extends DiagramImageAction<Display> {
    public CopyAsciiAction(Supplier<DiagramImageData> diagramImageDataSupplier, Display display) {
        super(diagramImageDataSupplier, display);
        this.setText("Copy as ASCII art");
    }

    public void run() {
        String s = "empty";
        try {
            DiagramImageData diagramImageData = this.getDiagramImageData();
            String source = diagramImageData.getDiagramData().getTextDiagram();
            SourceStringReader sourceStringReader = new SourceStringReader(source);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            sourceStringReader.outputImage((OutputStream)os, diagramImageData.getImageNum(), new FileFormatOption(FileFormat.ATXT));
            os.close();
            s = new String(os.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
            s = e.toString();
        }
        Clipboard clipboard = new Clipboard((Display)this.getContext());
        clipboard.setContents(new Object[]{s}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }
}

