/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.views.actions;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import java.util.function.Supplier;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.eclipse.utils.PlantumlUtil;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import net.sourceforge.plantuml.eclipse.views.actions.DiagramImageAction;
import net.sourceforge.plantuml.util.DiagramImageData;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportAction
extends DiagramImageAction<Shell> {
    public ExportAction(Supplier<DiagramImageData> diagramImageDataSupplier, Shell shell) {
        super(diagramImageDataSupplier, shell);
        this.setText("Export");
    }

    public void run() {
        FileDialog fDialog = new FileDialog((Shell)this.getContext(), 8192);
        fDialog.setFilterExtensions(new String[]{"*.png", "*.svg", "*.jpg", "*.gif"});
        fDialog.open();
        String fileName = fDialog.getFileName();
        if (StringUtils.isNotEmpty((String)fileName)) {
            String filePathName = String.valueOf(fDialog.getFilterPath()) + System.getProperty("file.separator") + fileName;
            String ext = fileName.substring(fileName.lastIndexOf(".") + 1);
            if ("svg".equals(ext)) {
                this.createImageFileSvg(filePathName, this.getDiagramImageData().getDiagramData().getTextDiagram());
            } else {
                this.createImageFile(filePathName, ext);
            }
        }
    }

    private void createImageFile(String filePathName, String format) {
        Function<Integer, String> fileNameProvider = PlantumlUtil.getImageFileNameProvider(filePathName);
        if (fileNameProvider != null) {
            int imageCount = this.getDiagramImageData().getDiagramData().getImageCount();
            int i = 0;
            while (i < imageCount) {
                this.createImageFile(fileNameProvider.apply(i), format, this.getDiagramImageData().getDiagramData().getImage(i, null));
                ++i;
            }
        } else {
            this.createImageFile(filePathName, format, this.getImage());
        }
    }

    private void createImageFile(String filePathName, String format, ImageData imageData) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{imageData};
        try {
            int swtFormat = SWT.class.getField("IMAGE_" + format.toUpperCase()).getInt(null);
            loader.save(filePathName, swtFormat);
        }
        catch (Exception e) {
            WorkbenchUtil.errorBox("Error during file generation for export.");
        }
    }

    private void createImageFileSvg(String filePathName, String textDiagram) {
        Function<Integer, String> fileNameProvider = PlantumlUtil.getImageFileNameProvider(filePathName);
        if (fileNameProvider != null) {
            int imageCount = this.getDiagramImageData().getDiagramData().getImageCount();
            int i = 0;
            while (i < imageCount) {
                this.createImageFileSvg(fileNameProvider.apply(i), textDiagram, i);
                ++i;
            }
        } else {
            this.createImageFileSvg(filePathName, textDiagram, this.getImageNum());
        }
    }

    private void createImageFileSvg(String filePathName, String textDiagram, int imageNum) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(filePathName);){
                SourceStringReader reader = new SourceStringReader(textDiagram);
                reader.outputImage((OutputStream)fos, imageNum, new FileFormatOption(FileFormat.SVG));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            WorkbenchUtil.errorBox("Error during file generation for export.");
        }
    }
}

