/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postprocessors;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.postprocessors.DiagramTextAfterFirstLineInjector;
import net.sourceforge.plantuml.postprocessors.DiagramTextInjector;
import net.sourceforge.plantuml.postprocessors.DiagramTextInjectorMatcher;
import net.sourceforge.plantuml.util.AbstractDiagramIntent;
import net.sourceforge.plantuml.util.AbstractProperties;
import net.sourceforge.plantuml.util.BasicProperties;
import net.sourceforge.plantuml.util.DiagramTextPostProcessor;

public class DiagramTextInjectionPostProcessor
implements DiagramTextPostProcessor {
    private Map<String, Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector>> diagramTextInjections;
    private final BasicProperties textInjectionsProperties = new BasicProperties(Activator.getDefault().getProperties(this.getClass()));

    public void setDdiagramTextInjection(String key, DiagramTextInjectorMatcher matcher, DiagramTextInjector injector) {
        this.setDiagramTextInjection(key, new AbstractMap.SimpleEntry<DiagramTextInjectorMatcher, DiagramTextInjector>(matcher, injector));
    }

    public void setDiagramTextInjection(String key, Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector> injection) {
        if (this.diagramTextInjections == null) {
            this.diagramTextInjections = new HashMap<String, Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector>>();
        }
        this.diagramTextInjections.put(key, injection);
    }

    private String getStringProperty(String value) {
        if (value.startsWith("\"")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private Pattern getRegexProperty(String value) {
        String regexString = this.getStringProperty(value);
        String whatever = "...";
        if (regexString.endsWith("...")) {
            regexString = DiagramTextInjectorMatcher.startsWithRegex(regexString.substring(0, regexString.length() - "...".length()));
        } else if (regexString.startsWith("...")) {
            regexString = DiagramTextInjectorMatcher.endsWithRegex(regexString.substring("...".length()));
        }
        return Pattern.compile(regexString);
    }

    @Override
    public String getDiagramText(String diagramText, AbstractDiagramIntent<?> diagramIntent) {
        if (this.diagramTextInjections == null) {
            this.initDiagramTextInjections();
        }
        if (this.diagramTextInjections != null) {
            for (Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector> injection : this.diagramTextInjections.values()) {
                if (!injection.getKey().matches(diagramText, diagramIntent.getContextProperties())) continue;
                return injection.getValue().getDiagramText(diagramText);
            }
        }
        return null;
    }

    private void initDiagramTextInjections() {
        this.initDiagramTextInjections(this.textInjectionsProperties);
    }

    private void initDiagramTextInjections(AbstractProperties props) {
        this.diagramTextInjections = new HashMap<String, Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector>>();
        for (String key : this.textInjectionsProperties.propertyNames()) {
            String prop = null;
            String value = props.getProperty(key, String.class, null);
            int pos = key.indexOf(46);
            if (pos > 0) {
                prop = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            DiagramTextInjectorMatcher matcher = null;
            Map.Entry<DiagramTextInjectorMatcher, DiagramTextInjector> injection = this.diagramTextInjections.get(key);
            if (injection == null) {
                injection = new AbstractMap.SimpleEntry<DiagramTextInjectorMatcher, Object>(new DiagramTextInjectorMatcher(), null);
                this.setDiagramTextInjection(key, injection);
            }
            matcher = injection.getKey();
            if (prop == null) {
                DiagramTextAfterFirstLineInjector injector = new DiagramTextAfterFirstLineInjector(this.getStringProperty(value));
                injection = new AbstractMap.SimpleEntry<DiagramTextInjectorMatcher, DiagramTextAfterFirstLineInjector>(matcher, injector);
                this.setDiagramTextInjection(key, injection);
                continue;
            }
            matcher.setPropertyRegex(prop, this.getRegexProperty(value));
        }
    }
}

