/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.postprocessors;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.util.AbstractProperties;

public class DiagramTextInjectorMatcher {
    private final Map<String, Pattern> contextPropertyPatterns = new HashMap<String, Pattern>();

    public void setPropertyRegex(String key, Pattern regex) {
        this.contextPropertyPatterns.put(key, regex);
    }

    public void setPropertyRegex(String key, String regex) {
        this.setPropertyRegex(key, Pattern.compile(regex));
    }

    public static String startsWithRegex(String s) {
        return "^" + Pattern.quote(s) + "(?s).*";
    }

    public void setPropertyStartsWith(String key, String s) {
        this.setPropertyRegex(key, DiagramTextInjectorMatcher.startsWithRegex(s));
    }

    public void setPropertyEndsWith(String key, String s) {
        this.setPropertyRegex(key, DiagramTextInjectorMatcher.endsWithRegex(s));
    }

    public static String endsWithRegex(String s) {
        return "(?s).*" + Pattern.quote(s) + "$";
    }

    private boolean doesntMatch(String key, String s) {
        return this.doesntMatch(this.contextPropertyPatterns.get(key), s);
    }

    private boolean doesntMatch(Pattern regex, String s) {
        return regex != null && (s == null || !regex.matcher(s).matches());
    }

    public boolean matches(String diagramText, AbstractProperties contextProperties) {
        if (this.doesntMatch("diagramText", diagramText)) {
            return false;
        }
        for (String key : contextProperties.propertyNames()) {
            if (!this.doesntMatch(key, (String)contextProperties.getProperty(key, String.class, null))) continue;
            return false;
        }
        return true;
    }
}

