/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preferences;

import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import net.sourceforge.plantuml.util.DiagramData;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label authorLabel;
    private Link plantumlLink;
    private Group graphvizGroup;
    private Label graphvizPathText;
    private FileFieldEditor graphvizPath;
    private Label testDotLabel;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(1, false));
        GridData authorsGridData = new GridData();
        authorsGridData.horizontalAlignment = 2;
        authorsGridData.horizontalSpan = 3;
        this.authorLabel = new Label(pnl, 2048);
        this.authorLabel.setLayoutData((Object)authorsGridData);
        ImageData authorsImg = null;
        ImageData testDotImg = null;
        try {
            authorsImg = new DiagramData("@startuml\nauthor\n@enduml").getImage();
            testDotImg = new DiagramData("@startuml\ntestdot\n@enduml").getImage();
        }
        catch (StackOverflowError e) {
            WorkbenchUtil.errorBox("Error during preferences loading.", e);
        }
        if (authorsImg != null) {
            this.authorLabel.setImage(new Image((Device)pnl.getDisplay(), authorsImg));
        }
        this.plantumlLink = new Link(pnl, 0);
        this.plantumlLink.setText("Visit the <a>PlantUML Website</a>.");
        this.plantumlLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://plantuml.com");
            }
        });
        this.graphvizGroup = new Group(pnl, 0);
        this.graphvizGroup.setText("Graphviz path");
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        this.graphvizGroup.setLayoutData((Object)groupGridData);
        this.graphvizPathText = new Label((Composite)this.graphvizGroup, 0);
        GridData labelGridData = new GridData();
        labelGridData.horizontalSpan = 3;
        this.graphvizPathText.setLayoutData((Object)labelGridData);
        this.graphvizPathText.setText("If the Graphviz software is not installed in the default directory, set the path in the field below.");
        this.graphvizPath = new FileFieldEditor("graphvizPath", "Path to the dot executable of Graphviz :", (Composite)this.graphvizGroup);
        this.graphvizPath.setStringValue(this.getPreferenceStore().getString("graphvizPath"));
        GridData testDotGridData = new GridData();
        testDotGridData.horizontalAlignment = 2;
        testDotGridData.horizontalSpan = 3;
        this.testDotLabel = new Label((Composite)this.graphvizGroup, 0);
        this.testDotLabel.setLayoutData((Object)testDotGridData);
        if (testDotImg != null) {
            this.testDotLabel.setImage(new Image((Device)this.graphvizGroup.getDisplay(), testDotImg));
        }
        this.graphvizPath.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ImageData testDotImg = null;
                OptionFlags.getInstance().setDotExecutable(WorkbenchPreferencePage.this.graphvizPath.getStringValue());
                try {
                    testDotImg = new DiagramData("@startuml\ntestdot\n@enduml").getImage();
                }
                catch (StackOverflowError e) {
                    WorkbenchUtil.errorBox("Error during preferences loading.", e);
                }
                if (testDotImg != null) {
                    WorkbenchPreferencePage.this.testDotLabel.setImage(new Image((Device)WorkbenchPreferencePage.this.graphvizGroup.getDisplay(), testDotImg));
                }
            }
        });
        return pnl;
    }

    protected void performDefaults() {
        this.graphvizPath.setStringValue("");
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (this.graphvizPath != null) {
            preferenceStore.setValue("graphvizPath", this.graphvizPath.getStringValue());
        }
        return true;
    }
}

