/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.util;

import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.util.AbstractProperties;
import net.sourceforge.plantuml.util.BasicProperties;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.ResourceInfo;

public abstract class AbstractDiagramIntent<T>
implements DiagramIntent {
    private final T source;
    private final String label;
    private final AbstractProperties contextProperties = new BasicProperties(null);
    private final AbstractProperties intentProperties = new BasicProperties(Activator.getDefault().getProperties(this.getClass()));
    public static int DEFAULT_PRIORITY = -1;
    public static int NORMAL_PRIORITY = 0;
    public static int SELECTED_PRIORITY = 1;
    private int priority = NORMAL_PRIORITY;
    private ResourceInfo resourceInfo;

    public T getSource() {
        return this.source;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public AbstractDiagramIntent(T source, String label) {
        this.source = source;
        this.label = label;
    }

    private static String firstLine(String s) {
        int pos = s.indexOf(10);
        return pos >= 0 ? s.substring(0, pos) : s;
    }

    public AbstractDiagramIntent(T source) {
        this(source, AbstractDiagramIntent.firstLine(source.toString()));
    }

    public String toString() {
        return this.source.toString();
    }

    public AbstractProperties getContextProperties() {
        return this.contextProperties;
    }

    public AbstractProperties getIntentProperties() {
        return this.intentProperties;
    }

    @Override
    public String getDiagramText() {
        return this.toString();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }
}

