/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class AbstractProperties {
    private final Class<?>[] valueOfParamTypes = new Class[]{String.class};

    protected abstract boolean hasProperty(String var1);

    protected abstract Object getProperty(String var1);

    protected abstract void putProperty(String var1, Object var2);

    public abstract Iterable<String> propertyNames();

    public void setProperty(String key, Object value) {
        if (value != null) {
            this.checkValueType(value);
        }
        this.putProperty(key, value);
    }

    private void checkValueType(Object value) throws IllegalArgumentException {
        this.checkValueType(value.getClass());
    }

    private void checkValueType(Class<?> valueClass) throws IllegalArgumentException {
        if (valueClass == String.class) {
            return;
        }
        try {
            Method m = valueClass.getMethod("valueOf", this.valueOfParamTypes);
            if (m.getReturnType() == valueClass && Modifier.isStatic(m.getModifiers())) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException(valueClass + " doesn't have a static valueOf(String) method");
    }

    public <T> T getProperty(String key, Class<T> valueClass, T def) {
        this.checkValueType(valueClass);
        if (!this.hasProperty(key)) {
            return def;
        }
        Object value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (valueClass == String.class) {
            return (T)String.valueOf(value);
        }
        try {
            return (T)valueClass.getMethod("valueOf", this.valueOfParamTypes).invoke(null, String.valueOf(value));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(value + " couldnt't be converted to " + valueClass);
        }
    }
}

