/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchUtil;
import net.sourceforge.plantuml.security.SFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;

public class DiagramData {
    private final String textDiagram;
    private int imageCount;
    private IPath original;
    private Map<String, Object> markerAttributes;
    private static final Pattern pattern = Pattern.compile("(?i)(?m)^\\W*newpage( .*)?$");
    private static FileFormatOption imageFileFormatOption = new FileFormatOption(FileFormat.PNG);
    private static FileFormatOption svgFileFormatOption = new FileFormatOption(FileFormat.SVG);

    public DiagramData(String diagramText) {
        this.textDiagram = diagramText;
        this.imageCount = 1;
        Matcher matcherNewpage = pattern.matcher(diagramText);
        while (matcherNewpage.find()) {
            ++this.imageCount;
        }
    }

    public String getTextDiagram() {
        return this.textDiagram;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setOriginal(IPath original) {
        this.original = original;
    }

    public IPath getOriginal() {
        return this.original;
    }

    public Map<String, Object> getMarkerAttributes() {
        return this.markerAttributes;
    }

    public void setMarkerAttributes(Map<String, Object> markerAttributes) {
        this.markerAttributes = markerAttributes;
    }

    public ImageData getImage(int imageNum, Collection<LinkData> links) {
        if (this.original != null) {
            IFile member = ResourcesPlugin.getWorkspace().getRoot().getFile(this.original);
            SFile dirPath = SFile.fromFile((File)member.getLocation().toFile().getAbsoluteFile().getParentFile());
            FileSystem.getInstance().setCurrentDir(dirPath);
        } else {
            FileSystem.getInstance().reset();
        }
        OptionFlags.getInstance().setQuiet(true);
        return DiagramData.getImage(this.textDiagram, imageNum, links);
    }

    public ImageData getImage() {
        return this.getImage(0, null);
    }

    private static void setGraphvizPath() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        String dotPath = prefStore.getString("graphvizPath");
        if (dotPath != null && !"".equals(dotPath)) {
            System.setProperty("GRAPHVIZ_DOT", dotPath);
        }
    }

    private static ImageData getImage(String textDiagram, int imageNum, Collection<LinkData> links) {
        ImageData imageData;
        block21: {
            DiagramData.setGraphvizPath();
            imageData = null;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    String cMapData;
                    SourceStringReader reader = new SourceStringReader(textDiagram);
                    DiagramDescription desc = reader.outputImage((OutputStream)os, imageNum, imageFileFormatOption);
                    if (links != null && (cMapData = reader.getCMapData(0, imageFileFormatOption)) != null) {
                        DiagramData.parseImageMapString(cMapData, links);
                    }
                    os.flush();
                    if (desc == null || !StringUtils.isNotEmpty((String)desc.getDescription())) break block21;
                    Throwable throwable2 = null;
                    Object var10_14 = null;
                    try (ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());){
                        imageData = new ImageData((InputStream)is);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                WorkbenchUtil.errorBox("Error during image generation.", e);
            }
        }
        return imageData;
    }

    private static void parseImageMapString(String cMapData, Collection<LinkData> links) {
        String[] areaElements;
        String[] stringArray = areaElements = cMapData.split(Pattern.quote("<area "));
        int n = areaElements.length;
        int n2 = 0;
        while (n2 < n) {
            String areaElement = stringArray[n2];
            String coords = DiagramData.getAttributeValue(areaElement, "coords");
            if (coords != null) {
                LinkData link = new LinkData();
                link.href = DiagramData.getAttributeValue(areaElement, "href");
                link.title = DiagramData.getAttributeValue(areaElement, "title");
                link.altText = DiagramData.getAttributeValue(areaElement, "alt");
                String[] ints = coords.split(",");
                if (ints.length == 4) {
                    try {
                        int x1 = Integer.valueOf(ints[0]);
                        int y1 = Integer.valueOf(ints[1]);
                        int x2 = Integer.valueOf(ints[2]);
                        int y2 = Integer.valueOf(ints[3]);
                        link.rect = new Rectangle(x1, y1, x2 - x1, y2 - y1);
                        links.add(link);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (links != null && links.size() > 0) {
            DiagramData.scaleLinks(links);
        }
    }

    private static void scaleLinks(Collection<LinkData> links) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (LinkData link : links) {
            if (link.rect.x < minX) {
                minX = link.rect.x;
            }
            if (link.rect.y >= minY) continue;
            minY = link.rect.y;
        }
        int marginX = 7;
        int marginY = 7;
        int sx = minX / 7;
        int sy = minY / 7;
        for (LinkData link : links) {
            link.rect.x /= sx;
            link.rect.y /= sy;
            link.rect.width /= sx;
            link.rect.height /= sy;
        }
    }

    private static String getAttributeValue(String element, String attributeName) {
        String prefix = String.valueOf(attributeName) + "=\"";
        int start = element.indexOf(prefix);
        if (start >= 0) {
            String suffix = "\"";
            int end = element.indexOf("\"", start += prefix.length());
            if (end > start) {
                return element.substring(start, end);
            }
        }
        return null;
    }

    public String getSvg(int imageNum) {
        DiagramData.setGraphvizPath();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                SourceStringReader reader = new SourceStringReader(this.textDiagram);
                DiagramDescription desc = reader.outputImage((OutputStream)os, imageNum, svgFileFormatOption);
                os.flush();
                if (desc != null && StringUtils.isNotEmpty((String)desc.getDescription())) {
                    return new String(os.toByteArray(), StandardCharsets.UTF_8);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            WorkbenchUtil.errorBox("Error during image generation.", e);
        }
        return null;
    }
}

