/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.util;

import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.eclipse.utils.LinkData;
import net.sourceforge.plantuml.util.DiagramData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.ImageData;

public class DiagramImageData {
    private final DiagramData diagramData;
    private final int imageNum;
    private ImageData imageData;
    private final Collection<LinkData> links = new ArrayList<LinkData>();

    public DiagramImageData(DiagramData diagram, int imageNum, ImageData imageData) {
        this.diagramData = diagram;
        this.imageNum = imageNum;
        this.imageData = imageData;
    }

    public DiagramImageData(DiagramData diagram, ImageData imageData) {
        this(diagram, 0, imageData);
    }

    public DiagramImageData(DiagramData diagram, int imageNum) {
        this(diagram, imageNum, null);
    }

    public DiagramImageData(DiagramData diagram) {
        this(diagram, 0);
    }

    public DiagramImageData withImageNum(int imageNum) {
        return new DiagramImageData(this.diagramData, imageNum);
    }

    public DiagramData getDiagramData() {
        return this.diagramData;
    }

    public IPath getSourcePath() {
        return this.diagramData.getOriginal();
    }

    public int getImageNum() {
        return this.imageNum;
    }

    public ImageData getImage() {
        if (this.imageData == null) {
            this.imageData = this.diagramData.getImage(this.imageNum, this.links);
        }
        return this.imageData;
    }

    public Iterable<LinkData> getLinks() {
        return this.links;
    }
}

