/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.util;

import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider;
import net.sourceforge.plantuml.eclipse.utils.DiagramTextProvider2;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.eclipse.utils.WorkspaceDiagramIntentProviderContext;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntentContext;
import net.sourceforge.plantuml.util.DiagramIntentProvider;
import net.sourceforge.plantuml.util.SimpleDiagramIntent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramTextIntentProvider
implements DiagramIntentProvider {
    private final DiagramTextProvider diagramTextProvider;

    public DiagramTextIntentProvider(DiagramTextProvider diagramTextProvider) {
        this.diagramTextProvider = diagramTextProvider;
    }

    public DiagramTextProvider getDiagramTextProvider() {
        return this.diagramTextProvider;
    }

    public Collection<DiagramIntent> getDiagramInfos(DiagramIntentContext context) {
        WorkspaceDiagramIntentProviderContext intentProviderContext;
        DiagramTextProvider2 diagramTextProvider2;
        String diagramText = null;
        if (context instanceof WorkbenchPartDiagramIntentProviderContext) {
            WorkbenchPartDiagramIntentProviderContext intentProviderContext2 = (WorkbenchPartDiagramIntentProviderContext)context;
            IWorkbenchPart workbenchPart = intentProviderContext2.getWorkbenchPart();
            ISelection selection = intentProviderContext2.getSelection();
            if (workbenchPart instanceof IEditorPart) {
                if (this.diagramTextProvider instanceof DiagramTextProvider2) {
                    DiagramTextProvider2 diagramTextProvider22 = (DiagramTextProvider2)this.diagramTextProvider;
                    diagramText = diagramTextProvider22.getDiagramText((IEditorPart)workbenchPart, selection);
                } else {
                    diagramText = this.diagramTextProvider.getDiagramText((IEditorPart)workbenchPart, selection);
                }
            } else if (workbenchPart instanceof IViewPart) {
                diagramText = this.diagramTextProvider.getDiagramText((IViewPart)workbenchPart, selection);
            }
        } else if (context instanceof WorkspaceDiagramIntentProviderContext && this.diagramTextProvider instanceof DiagramTextProvider2 && (diagramTextProvider2 = (DiagramTextProvider2)this.diagramTextProvider).supportsPath((intentProviderContext = (WorkspaceDiagramIntentProviderContext)context).getPath())) {
            diagramText = diagramTextProvider2.getDiagramText(intentProviderContext.getPath());
        }
        if (diagramText != null) {
            return Collections.singletonList(new SimpleDiagramIntent(diagramText));
        }
        return null;
    }
}

