/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import java.util.Locale;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.ColorManager;
import org.eclipse.ant.internal.ui.editor.DecayCodeCompletionDataStructuresThread;
import org.eclipse.ant.internal.ui.editor.text.AntEditorDocumentProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class AntUIPlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 120;
    private static AntUIPlugin plugin;
    public static final String PI_ANTUI = "org.eclipse.ant.ui";
    private IPreferenceStore fCombinedPreferenceStore;
    private IDocumentProvider fDocumentProvider;

    public AntUIPlugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            AntUIImages.disposeImageDescriptorRegistry();
            DecayCodeCompletionDataStructuresThread.cancel();
            ColorManager.getDefault().dispose();
        }
        finally {
            super.stop(context);
        }
    }

    public static AntUIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        return PI_ANTUI;
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PI_ANTUI, 120, "Error logged from Ant UI: ", t);
        AntUIPlugin.log((IStatus)status);
    }

    public static void log(IStatus status) {
        AntUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = AntUIPlugin.newErrorStatus(message, exception);
        AntUIPlugin.log(status);
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            return new Status(4, PI_ANTUI, 0, "", exception);
        }
        return new Status(4, PI_ANTUI, 0, message, exception);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    protected ImageRegistry createImageRegistry() {
        return AntUIImages.initializeImageRegistry();
    }

    public static Color getPreferenceColor(String pref) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)AntUIPlugin.getDefault().getCombinedPreferenceStore(), (String)pref));
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = AntUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static boolean isMacOS() {
        String osname = System.getProperty("os.name").toLowerCase(Locale.US);
        return osname.contains("mac");
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public synchronized IDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new AntEditorDocumentProvider();
        }
        return this.fDocumentProvider;
    }
}

