/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.runnabledependency;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.INamed;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.OsEvent;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.GraphvizGeneratorConfig;
import org.eclipse.emf.ecore.EObject;

public class GraphvizGenerator {
    private static final int MAX_MODEL_SIZE = 200;
    private GraphvizGeneratorConfig config;
    private BiMap<Object, String> idMap = HashBiMap.create();
    private boolean limitModelSize;
    private boolean createHyperlinks;

    public GraphvizGenerator(GraphvizGeneratorConfig config, boolean limitModelSize, boolean createHyperlinks) {
        this.config = config;
        this.limitModelSize = limitModelSize;
        this.createHyperlinks = createHyperlinks;
    }

    private Runnable buildCallChain(List<ActivityGraphItem> lst, Runnable prevRunnable, Set<EObject> inputs, Multimap<Object, Runnable> sources, Multimap<Object, Runnable> targets) {
        Runnable lastRunnable = prevRunnable;
        for (ActivityGraphItem itm : lst) {
            if (itm instanceof RunnableCall) {
                Runnable r = ((RunnableCall)itm).getRunnable();
                for (EObject o : inputs) {
                    targets.put((Object)o, (Object)r);
                }
                inputs.clear();
                if (lastRunnable != null) {
                    sources.put((Object)lastRunnable, (Object)lastRunnable);
                    targets.put((Object)lastRunnable, (Object)r);
                }
                lastRunnable = r;
                continue;
            }
            if (itm instanceof SetEvent) {
                if (lastRunnable == null) continue;
                for (OsEvent e : ((SetEvent)itm).getEventMask().getEvents()) {
                    sources.put((Object)e, (Object)lastRunnable);
                }
                continue;
            }
            if (itm instanceof WaitEvent) {
                inputs.addAll((Collection<EObject>)((WaitEvent)itm).getEventMask().getEvents());
                continue;
            }
            if (itm instanceof InterProcessTrigger) {
                if (lastRunnable == null) continue;
                sources.put((Object)((InterProcessTrigger)itm).getStimulus(), (Object)lastRunnable);
                continue;
            }
            if (!(itm instanceof Group)) continue;
            lastRunnable = this.buildCallChain((List<ActivityGraphItem>)((Group)itm).getItems(), lastRunnable, inputs, sources, targets);
        }
        return lastRunnable;
    }

    private void buildCallGraph(SWModel model, StringBuilder sb) {
        SetMultimap sources = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        SetMultimap targets = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        LinkedHashSet stims = new LinkedHashSet();
        for (Task t : model.getTasks()) {
            stims.addAll(t.getStimuli());
            this.buildCallChain((List<ActivityGraphItem>)t.getActivityGraph().getItems(), null, new LinkedHashSet<EObject>((Collection<EObject>)t.getStimuli()), (Multimap<Object, Runnable>)sources, (Multimap<Object, Runnable>)targets);
        }
        sb.append("node[shape=\"ellipse\"];" + System.lineSeparator());
        for (Stimulus s : stims) {
            if (s instanceof InterProcessStimulus) continue;
            for (Runnable r : targets.get((Object)s)) {
                sb.append("\"" + this.getName((INamed)s) + "\" -> ");
                sb.append(this.getID(r));
                sb.append(System.lineSeparator());
            }
        }
        for (Map.Entry e : sources.entries()) {
            for (Runnable r : targets.get(e.getKey())) {
                sb.append(this.getID(e.getValue()));
                sb.append(" -> ");
                sb.append(this.getID(r));
                if (e.getKey() instanceof Runnable) {
                    sb.append("[style=\"dashed\"]");
                } else if (e.getKey() instanceof INamed) {
                    sb.append("[label=\"" + ((EObject)e.getKey()).eClass().getName() + " " + ((INamed)e.getKey()).getName() + "\"]");
                }
                sb.append(System.lineSeparator());
            }
        }
    }

    private void buildNode(StringBuilder sb, Runnable runnable, Set<Label> reads, Set<Label> writes, int idx) {
        sb.append(this.getID(runnable));
        sb.append("[shape=\"Mrecord\", color=\"");
        sb.append(this.getColor(idx));
        sb.append("\",label=\"{");
        if (this.config.isShowLabels()) {
            this.buildPortList(sb, reads, "R");
            sb.append("|");
            sb.append(runnable.getName());
            sb.append("|");
            this.buildPortList(sb, writes, "W");
        } else {
            sb.append(runnable.getName());
        }
        sb.append("}\"");
        if (this.createHyperlinks) {
            sb.append(", URL=\"#" + this.getID(runnable) + "\"");
        }
        sb.append("];");
        sb.append(System.lineSeparator());
    }

    private void buildPortList(StringBuilder sb, Set<Label> labels, String dir) {
        sb.append("{");
        sb.append(String.join((CharSequence)"|", (CharSequence[])labels.stream().sorted((a, b) -> this.getName((INamed)a).compareTo(this.getName((INamed)b))).map(label -> "<" + dir + this.getID(label) + ">" + this.getName((INamed)label)).toArray(String[]::new)));
        sb.append("}");
    }

    private void buildTaskGroups(SWModel sw, StringBuilder sb) {
        int cnt = 0;
        sb.append("newrank=true");
        sb.append(System.lineSeparator());
        for (Task t : sw.getTasks()) {
            sb.append("subgraph cluster");
            sb.append(cnt++);
            sb.append(" {");
            sb.append(System.lineSeparator());
            sb.append("fontname=\"Helvetica\"");
            sb.append(System.lineSeparator());
            sb.append("label=\"");
            sb.append(t.getName());
            sb.append("\"");
            sb.append(System.lineSeparator());
            for (Runnable r : SoftwareUtil.getRunnableList((Process)t, null)) {
                sb.append(this.getID(r));
                sb.append(System.lineSeparator());
            }
            sb.append("}");
            sb.append(System.lineSeparator());
        }
    }

    public String createDot(SWModel model) {
        if (this.limitModelSize && model.getRunnables().size() > 200) {
            return "digraph model {\"The model contains more than 200 Runnables and thus is too large to be visualized.\"}";
        }
        SetMultimap labelReads = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        SetMultimap labelWrites = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        StringBuilder sb = new StringBuilder();
        sb.append("digraph model {");
        sb.append(System.lineSeparator());
        sb.append("node [shape=\"Mrecord\", fontname=\"Helvetica\"];");
        sb.append(System.lineSeparator());
        sb.append("edge [fontname=\"Helvetica\"];");
        sb.append(System.lineSeparator());
        if (this.config.isHorizontalLayout()) {
            sb.append("rankdir=LR;");
            sb.append(System.lineSeparator());
        }
        int i = 0;
        if (this.config.isShowCallDependencies()) {
            this.buildCallGraph(model, sb);
        }
        if (this.config.isShowTasks()) {
            this.buildTaskGroups(model, sb);
        }
        sb.append("node [shape=\"Mrecord\", fontname=\"Helvetica\"];");
        sb.append(System.lineSeparator());
        for (Runnable runnable : model.getRunnables()) {
            Set reads = SoftwareUtil.getReadLabelSet((Runnable)runnable, null);
            labelReads.putAll((Object)runnable, (Iterable)reads);
            Set writes = SoftwareUtil.getWriteLabelSet((Runnable)runnable, null);
            labelWrites.putAll((Object)runnable, (Iterable)writes);
            this.buildNode(sb, runnable, reads, writes, i++);
        }
        if (this.config.isShowLabelDependencies()) {
            Multimap readers = Multimaps.invertFrom((Multimap)labelReads, (Multimap)MultimapBuilder.linkedHashKeys().linkedHashSetValues().build());
            HashSet connections = new HashSet();
            labelWrites.forEach((writer, label) -> readers.get(label).forEach(reader -> {
                if (writer == reader || !this.config.isShowLabels() && !connections.add(Arrays.asList(writer, reader))) {
                    return;
                }
                sb.append(this.getID(writer));
                if (this.config.isShowLabels()) {
                    sb.append(":W");
                    sb.append(this.getID(label));
                }
                sb.append(this.config.isHorizontalLayout() ? ":e -> " : ":s -> ");
                sb.append(this.getID(reader));
                if (this.config.isShowLabels()) {
                    sb.append(":R");
                    sb.append(this.getID(label));
                }
                sb.append(this.config.isHorizontalLayout() ? ":w[color=\"" : ":n[color=\"");
                sb.append(this.getColor(model.getRunnables().indexOf(writer)));
                sb.append("\"];");
                sb.append(System.lineSeparator());
            }));
        }
        sb.append("}");
        return sb.toString();
    }

    private String getColor(int n) {
        int colorBits = 0;
        int i = 0;
        while (i < 24) {
            if ((n & 1 << i) != 0) {
                colorBits |= 1 << 8 * (i % 3) + 7 - i / 3;
            }
            ++i;
        }
        return String.format("#%06x", colorBits);
    }

    private String getID(Object obj) {
        return (String)this.idMap.computeIfAbsent(obj, k -> "obj" + this.idMap.size());
    }

    private String getName(INamed obj) {
        return obj.getName() != null ? obj.getName() : "<unnamed>";
    }

    public Object getObjectById(String id) {
        return this.idMap.inverse().get((Object)id);
    }
}

