/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.eclipse.utils.WorkspaceDiagramIntentProviderContext;
import net.sourceforge.plantuml.jdt.JdtDiagramIntent;
import net.sourceforge.plantuml.text.AbstractDiagramIntentProvider;
import net.sourceforge.plantuml.util.DiagramIntent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaEditorDiagramIntentProvider
extends AbstractDiagramIntentProvider {
    public JavaEditorDiagramIntentProvider() {
        this.setEditorType(ITextEditor.class);
    }

    protected Collection<DiagramIntent> getDiagramInfos(WorkbenchPartDiagramIntentProviderContext context) {
        IEditorInput editorInput;
        if (context.getWorkbenchPart() instanceof IEditorPart && (editorInput = ((IEditorPart)context.getWorkbenchPart()).getEditorInput()) instanceof IFileEditorInput) {
            return this.getDiagramInfos(((IFileEditorInput)editorInput).getFile());
        }
        return null;
    }

    protected Boolean supportsPath(IPath path) {
        return "java".equals(path.getFileExtension());
    }

    private Collection<DiagramIntent> getDiagramInfos(IFile file) {
        if (file != null && this.supportsPath(file.getFullPath()).booleanValue()) {
            ICompilationUnit compUnit = JavaCore.createCompilationUnitFrom((IFile)file);
            try {
                compUnit.open((IProgressMonitor)new NullProgressMonitor());
                return Collections.singletonList(new JdtDiagramIntent(Arrays.asList(compUnit.getTypes())));
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Collection<DiagramIntent> getDiagramInfos(WorkspaceDiagramIntentProviderContext context) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(context.getPath());
        return this.getDiagramInfos(file);
    }
}

