/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.eclipse.utils.WorkbenchPartDiagramIntentProviderContext;
import net.sourceforge.plantuml.jdt.JdtDiagramIntent;
import net.sourceforge.plantuml.text.AbstractDiagramIntentProvider;
import net.sourceforge.plantuml.util.DiagramIntent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class JavaViewDiagramIntentProvider
extends AbstractDiagramIntentProvider {
    public JavaViewDiagramIntentProvider() {
        this.setViewType(IViewPart.class);
    }

    protected Collection<DiagramIntent> getDiagramInfos(WorkbenchPartDiagramIntentProviderContext context) {
        Collection<IType> javaElements = this.getSelectedTypes(context.getSelection());
        return Collections.singletonList(new JdtDiagramIntent(javaElements));
    }

    public Boolean supportsSelection(ISelection selection) {
        Collection<IType> selectedTypes = this.getSelectedTypes(selection);
        if (selectedTypes != null && !selectedTypes.isEmpty()) {
            return true;
        }
        return false;
    }

    protected Collection<IType> getSelectedTypes(ISelection selection) {
        ArrayList<IType> javaElements = new ArrayList<IType>();
        if (selection instanceof IStructuredSelection) {
            for (Object next : (IStructuredSelection)selection) {
                if (!(next instanceof IJavaElement)) continue;
                this.addJavaElements((IJavaElement)next, javaElements);
            }
        }
        return javaElements;
    }

    protected void addJavaElements(IJavaElement javaElement, Collection<IType> javaElements) {
        if (javaElement instanceof ICompilationUnit) {
            try {
                IType[] types = ((ICompilationUnit)javaElement).getTypes();
                if (types != null && types.length > 0) {
                    javaElements.add(types[0]);
                }
            }
            catch (JavaModelException types) {}
        } else if (javaElement instanceof IPackageFragment) {
            try {
                ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)javaElement).getCompilationUnits();
                int n = iCompilationUnitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompilationUnit compUnit = iCompilationUnitArray[n2];
                    this.addJavaElements((IJavaElement)compUnit, javaElements);
                    ++n2;
                }
                iCompilationUnitArray = ((IPackageFragmentRoot)javaElement.getParent()).getChildren();
                n = iCompilationUnitArray.length;
                n2 = 0;
                while (n2 < n) {
                    ICompilationUnit packageFragment = iCompilationUnitArray[n2];
                    if (packageFragment != javaElement && javaElement.getPath().isPrefixOf(packageFragment.getPath())) {
                        this.addJavaElements((IJavaElement)packageFragment, javaElements);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        } else if (javaElement instanceof IType) {
            javaElements.add((IType)javaElement);
        }
    }
}

