/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import net.sourceforge.plantuml.eclipse.utils.DiagramIntentProperty;
import net.sourceforge.plantuml.text.AbstractClassDiagramIntent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JdtDiagramIntent
extends AbstractClassDiagramIntent<Collection<IType>> {
    public static final String JAVA_CLASS_DIAGRAM__USE_JAVA_LINKS = "javaClassDiagram.useJavaLinks";
    private final int genFlags = GEN_MEMBERS | GEN_MODIFIERS | GEN_EXTENDS | GEN_IMPLEMENTS | GEN_ASSOCIATIONS | GEN_CLASS_HYPERLINKS;
    private final Collection<String> multiAssociationClassNames = new HashSet<String>(Arrays.asList("java.util.Collection", "java.util.List", "java.util.Set"));
    private final Collection<String> optionalAssociationClassNames = new HashSet<String>(Arrays.asList(Optional.class.getName()));

    public JdtDiagramIntent(Collection<IType> source) {
        super(source, "Class diagram");
    }

    public String getDiagramText() {
        StringBuilder result = new StringBuilder();
        ArrayList<IType> allTypes = new ArrayList<IType>((Collection)this.getSource());
        for (IType type : allTypes) {
            this.generateForType(type, result, allTypes);
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public void generateForType(IType type, StringBuilder result, Collection<IType> allTypes) {
        this.generateForType(type, result, this.genFlags, allTypes);
    }

    private boolean isInTypes(String typeName, Collection<IType> allTypes) {
        for (IType type : allTypes) {
            if (!this.getTypeName(type, false).equals(typeName) && !this.getTypeName(type, true).equals(typeName) && !type.getFullyQualifiedName().equals(typeName)) continue;
            return true;
        }
        return false;
    }

    public void addMultiAssociationClassName(String className) {
        this.multiAssociationClassNames.add(className);
    }

    public void addOptionalAssociationClassName(String className) {
        this.optionalAssociationClassNames.add(className);
    }

    protected AssociationCardinality guessAssociationCardinality(IType type) {
        if (type == null) {
            return AssociationCardinality.UNKNOWN;
        }
        if (this.isSubtypeOf(type, this.optionalAssociationClassNames)) {
            return AssociationCardinality.OPTIONAL;
        }
        if (this.isSubtypeOf(type, this.multiAssociationClassNames)) {
            return AssociationCardinality.MULTIPLE;
        }
        return AssociationCardinality.UNKNOWN;
    }

    private boolean isSubtypeOf(IType type, Collection<String> superInterfaces) {
        String[] superInterfaceNames;
        block5: {
            if (type == null) {
                return false;
            }
            String fullyQualifiedName = type.getFullyQualifiedName();
            if (superInterfaces.contains(fullyQualifiedName)) {
                return true;
            }
            try {
                superInterfaceNames = type.getSuperInterfaceNames();
                if (!Stream.of(superInterfaceNames).anyMatch(superInterfaces::contains)) break block5;
                return true;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        IJavaProject javaProject = type.getJavaProject();
        return Stream.of(superInterfaceNames).map(name -> this.findType((String)name, javaProject)).anyMatch(superType -> this.isSubtypeOf((IType)superType, superInterfaces));
    }

    private IType findType(String name, IJavaProject javaProject) {
        try {
            return javaProject.findType(name);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    @DiagramIntentProperty(name="javaClassDiagram.useJavaLinks", type=Boolean.class)
    protected boolean isUseJavaLinks() {
        return (Boolean)this.getIntentProperties().getProperty(JAVA_CLASS_DIAGRAM__USE_JAVA_LINKS, Boolean.class, (Object)true);
    }

    protected String getHyperlink(IType type) {
        if (this.isUseJavaLinks()) {
            return "java:" + type.getFullyQualifiedName();
        }
        IResource resource = type.getResource();
        if (resource != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public void generateForType(IType type, StringBuilder result, int genFlags, Collection<IType> allTypes) {
        ArrayList<Assoc> associations = JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) ? new ArrayList<Assoc>() : null;
        result.append(this.getClassType(type));
        result.append(" ");
        this.appendNameDeclaration(this.getTypeName(type, true), result);
        if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_CLASS_HYPERLINKS})) {
            this.appendLink(this.getHyperlink(type), false, result);
        }
        result.append(" {\n");
        try {
            StringBuilder body = new StringBuilder();
            if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_MEMBERS})) {
                String visibility;
                String modifiers;
                Assoc assoc;
                IField[] iFieldArray = type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    assoc = null;
                    if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) && this.acceptAssociation(type, (IMember)field)) {
                        assoc = this.generateAssociation(type, field);
                    }
                    if (associations != null && assoc != null && this.isInTypes(assoc.targetName, allTypes)) {
                        assoc.name = field.getElementName();
                        associations.add(assoc);
                    } else if (Flags.isEnum((int)type.getFlags())) {
                        this.appendAttribute(null, null, null, field.getElementName(), body);
                    } else {
                        modifiers = null;
                        visibility = null;
                        if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_MODIFIERS}) && !Flags.isInterface((int)type.getFlags())) {
                            modifiers = this.getMemberModifiers((IMember)field);
                            visibility = this.getMemberVisibilityModifier((IMember)field);
                        }
                        this.appendAttribute(modifiers, visibility, this.getTypeName(field.getTypeSignature(), true), field.getElementName(), body);
                    }
                    ++n2;
                }
                iFieldArray = type.getMethods();
                n = iFieldArray.length;
                n2 = 0;
                while (n2 < n) {
                    IField method = iFieldArray[n2];
                    assoc = null;
                    if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) && this.acceptAssociation(type, (IMember)method)) {
                        assoc = this.generateAssociation(type, (IMethod)method);
                    }
                    if (associations != null && assoc != null && this.isInTypes(assoc.targetName, allTypes)) {
                        assoc.name = String.valueOf(method.getElementName()) + "()";
                        associations.add(assoc);
                    } else {
                        modifiers = null;
                        visibility = null;
                        if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_MODIFIERS}) && !Flags.isInterface((int)type.getFlags())) {
                            modifiers = this.getMemberModifiers((IMember)method);
                            visibility = this.getMemberVisibilityModifier((IMember)method);
                        }
                        String typePart = method.isConstructor() ? null : this.getTypeName(method.getReturnType(), true);
                        ArrayList<String> parameters = new ArrayList<String>();
                        String[] parameterTypes = method.getParameterTypes();
                        String[] parameterNames = null;
                        parameterNames = method.getParameterNames();
                        int i = 0;
                        while (i < method.getNumberOfParameters()) {
                            String param = this.getTypeName(parameterTypes[i], true);
                            if (parameterNames != null) {
                                param = this.isJavaStyle() ? String.valueOf(param) + " " + parameterNames[i] : String.valueOf(parameterNames[i]) + this.getNameTypeSeparator() + param;
                            }
                            parameters.add(param);
                            ++i;
                        }
                        this.appendOperation(modifiers, visibility, typePart, method.getElementName(), parameters, body);
                    }
                    ++n2;
                }
            }
            result.append((CharSequence)body);
        }
        catch (JavaModelException body) {
            // empty catch block
        }
        result.append("}\n");
        if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_ASSOCIATIONS}) && associations != null) {
            for (Assoc assoc : associations) {
                this.generateRelatedType(type, assoc.targetName, "-->", null, result, genFlags, null, assoc.name, assoc.cardinalityLabel);
            }
        }
        try {
            if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_EXTENDS})) {
                this.generateRelatedType(type, this.getTypeName(type.getSuperclassTypeSignature(), true), "<|--", type.isInterface() ? "interface" : null, result, genFlags);
            }
            if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_IMPLEMENTS})) {
                String[] interfaceSignatures = type.getSuperInterfaceTypeSignatures();
                int i = 0;
                while (i < interfaceSignatures.length) {
                    this.generateRelatedType(type, this.getTypeName(interfaceSignatures[i], true), type.isInterface() ? "<|--" : "<|..", "interface", result, genFlags);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    protected String getTypeName(IType type, boolean includeTypeParameters) {
        String typeName = type.getElementName();
        if (includeTypeParameters) {
            try {
                ITypeParameter[] typeParameters = type.getTypeParameters();
                int i = 0;
                while (i < typeParameters.length) {
                    ITypeParameter typeParameter = typeParameters[i];
                    typeName = String.valueOf(typeName) + (i == 0 ? "<" : ",");
                    typeName = String.valueOf(typeName) + typeParameter.getElementName();
                    if (i == typeParameters.length - 1) {
                        typeName = String.valueOf(typeName) + ">";
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return typeName;
    }

    protected boolean acceptAssociation(IType type, IMember member) {
        try {
            int flags = member.getFlags();
            return !Flags.isEnum((int)flags) && !Flags.isStatic((int)flags);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected Assoc generateAssociation(IType type, IField field) throws JavaModelException {
        String fieldSignature = field.getTypeSignature();
        return this.generateAssociation(type, fieldSignature);
    }

    protected Assoc generateAssociation(IType type, IMethod method) throws JavaModelException {
        if (method.getNumberOfParameters() == 0) {
            String fieldSignature = method.getReturnType();
            return this.generateAssociation(type, fieldSignature);
        }
        return null;
    }

    protected Assoc generateAssociation(IType type, String fieldSignature) throws JavaModelException {
        String fieldTypeName = this.getTypeName(fieldSignature, true);
        Assoc assoc = new Assoc();
        if (fieldTypeName.endsWith("[]")) {
            assoc.targetName = fieldTypeName.substring(0, fieldTypeName.length() - 2);
            assoc.cardinalityLabel = AssociationCardinality.MULTIPLE.label;
        } else {
            assoc.targetName = fieldTypeName;
            String[][] resolvedFieldType = type.resolveType(fieldTypeName);
            String[] typeArguments = Signature.getTypeArguments((String)fieldSignature);
            if (resolvedFieldType != null && resolvedFieldType.length > 0 && typeArguments != null && typeArguments.length == 1) {
                assoc.targetName = this.getTypeName(typeArguments[0], true);
                String className = Signature.toQualifiedName((String[])resolvedFieldType[0]);
                String label = this.guessAssociationCardinality((IType)type.getJavaProject().findType((String)className)).label;
                assoc.cardinalityLabel = label != null ? label : fieldTypeName;
            } else {
                assoc.cardinalityLabel = AssociationCardinality.SINGLE.label;
            }
        }
        return assoc;
    }

    private void generateRelatedType(IType type, String className, String relation, String classType, StringBuilder result, int genFlags) {
        this.generateRelatedType(type, className, relation, classType, result, genFlags, null, null, null);
    }

    private void generateRelatedType(IType type, String className, String relation, String classType, StringBuilder result, int genFlags, String startLabel, String middleLabel, String endLabel) {
        if (className != null && !className.equals("Object")) {
            String link = null;
            if (JdtDiagramIntent.includes((int)genFlags, (int[])new int[]{GEN_CLASS_HYPERLINKS})) {
                try {
                    IType relatedType = type.getJavaProject().findType(className);
                    if (relatedType != null) {
                        link = this.getHyperlink(relatedType);
                    }
                }
                catch (CoreException relatedType) {
                    // empty catch block
                }
            }
            this.appendClassStart(null, classType != null ? classType : "class", className, link, result);
            this.appendClassEnd(result);
            String typeName = this.getTypeName(type, true);
            if (relation == "-->") {
                this.appendRelation(typeName, false, startLabel, relation, null, className, false, endLabel, middleLabel, result);
            } else {
                this.appendRelation(className, false, startLabel, relation, null, typeName, false, endLabel, middleLabel, result);
            }
        }
    }

    protected String getTypeName(String signature, boolean includeTypeParameters) {
        if (signature != null) {
            int pos;
            if (!includeTypeParameters && (pos = signature.indexOf(60)) > 0) {
                signature = signature.substring(0, pos);
            }
            return Signature.toString((String)signature).replace("java.lang.", "");
        }
        return null;
    }

    private String getMemberModifiers(IMember member) {
        try {
            String modifiers = "";
            int flags = member.getFlags();
            if (Flags.isStatic((int)flags)) {
                modifiers = String.valueOf(modifiers) + "{static}";
            } else if (Flags.isAbstract((int)flags)) {
                modifiers = String.valueOf(modifiers) + "{abstract}";
            }
            return modifiers.length() > 0 ? modifiers : null;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private String getMemberVisibilityModifier(IMember member) throws JavaModelException {
        int flags;
        block6: {
            block5: {
                try {
                    flags = member.getFlags();
                    if (!Flags.isPrivate((int)flags)) break block5;
                    return "-";
                }
                catch (JavaModelException e) {
                    return "";
                }
            }
            if (!Flags.isProtected((int)flags)) break block6;
            return "#";
        }
        if (Flags.isPublic((int)flags)) {
            return "+";
        }
        return "~";
    }

    private String getClassType(IType type) {
        int flags;
        block6: {
            block5: {
                try {
                    flags = type.getFlags();
                    if (!Flags.isEnum((int)flags)) break block5;
                    return "enum";
                }
                catch (JavaModelException e) {
                    return "";
                }
            }
            if (!Flags.isInterface((int)flags)) break block6;
            return "interface";
        }
        if (Flags.isAbstract((int)flags)) {
            return "abstract class";
        }
        return "class";
    }

    private static class Assoc {
        String name;
        String targetName;
        String cardinalityLabel;

        private Assoc() {
        }
    }

    public static enum AssociationCardinality {
        SINGLE("1"),
        OPTIONAL("0..1"),
        MULTIPLE("*"),
        UNKNOWN(null);

        public final String label;

        private AssociationCardinality(String indicator) {
            this.label = indicator;
        }
    }
}

