/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jdt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sourceforge.plantuml.eclipse.views.PlantUmlView;
import net.sourceforge.plantuml.jdt.Activator;
import net.sourceforge.plantuml.jdt.JdtDiagramIntent;
import net.sourceforge.plantuml.text.AbstractClassDiagramIntent;
import net.sourceforge.plantuml.util.DiagramIntent;
import net.sourceforge.plantuml.util.SimpleDiagramIntent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class JdtPlantUmlView
extends PlantUmlView
implements IPropertyChangeListener {
    private Collection<IJavaElement> rootSet = new ArrayList<IJavaElement>();
    private IPreferenceStore preferenceStore;
    private final int genFlags = AbstractClassDiagramIntent.GEN_MEMBERS | AbstractClassDiagramIntent.GEN_MODIFIERS | AbstractClassDiagramIntent.GEN_EXTENDS | AbstractClassDiagramIntent.GEN_IMPLEMENTS | AbstractClassDiagramIntent.GEN_ASSOCIATIONS | AbstractClassDiagramIntent.GEN_CLASS_HYPERLINKS;
    public static final String[] ALL_PACKAGE_STYLES = new String[]{"Folder", "Rectangle", "Frame", "Cloud", "Database"};
    private String packageStyle = null;
    private final String packageColor;

    public JdtPlantUmlView() {
        this.packageColor = null;
    }

    public boolean isLinkedToActivePart() {
        return false;
    }

    public void dispose() {
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.preferenceStore = null;
        }
    }

    public void createPartControl(Composite parent) {
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        super.createPartControl(parent);
        DropTarget dropTarget = new DropTarget((Control)parent, 17);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        dropTarget.setTransfer(transfers);
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }

            public void drop(DropTargetEvent event) {
                ISelection data;
                ArrayList<IJavaElement> rootSet = null;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (data = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                    for (Object next : (IStructuredSelection)data) {
                        Object javaElement = Platform.getAdapterManager().getAdapter(next, IJavaElement.class);
                        if (javaElement == null) continue;
                        if (rootSet == null) {
                            rootSet = new ArrayList<IJavaElement>();
                        }
                        if (rootSet.contains(javaElement)) continue;
                        rootSet.add((IJavaElement)javaElement);
                    }
                }
                JdtPlantUmlView.this.setVisible(true);
                if (rootSet != null && !rootSet.isEmpty()) {
                    JdtPlantUmlView.this.setRootSet((Collection<IJavaElement>)rootSet);
                }
            }
        });
    }

    protected void setRootSet(Collection<IJavaElement> col) {
        this.rootSet = new ArrayList<IJavaElement>(col);
        this.updateView();
    }

    protected void contributeToActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.addZoomActions((IContributionManager)toolBarManager);
    }

    private void updateView() {
        boolean generatePackages = this.preferenceStore != null && this.preferenceStore.getBoolean("generatePackages");
        String string = this.packageStyle = this.preferenceStore != null ? this.preferenceStore.getString("packageStyle") : null;
        if (this.packageStyle == null || this.packageStyle.length() == 0) {
            this.packageStyle = ALL_PACKAGE_STYLES[0];
        }
        StringBuilder result = new StringBuilder();
        result.append("@startuml\n");
        HashSet<IType> allTypes = new HashSet<IType>();
        this.addTypes(this.rootSet, allTypes);
        if (generatePackages) {
            HashMap<String, ArrayList<IType>> packageTypes = new HashMap<String, ArrayList<IType>>();
            for (IType iType : allTypes) {
                String packageName = iType.getPackageFragment().getElementName();
                ArrayList<IType> types = (ArrayList<IType>)packageTypes.get(packageName);
                if (types == null) {
                    types = new ArrayList<IType>();
                    packageTypes.put(packageName, types);
                }
                types.add(iType);
            }
            for (Map.Entry entry : packageTypes.entrySet()) {
                this.generatePackage((String)entry.getKey(), (Collection)entry.getValue(), result);
            }
        } else {
            this.generateTypes(allTypes, result);
        }
        result.append("\n@enduml");
        this.updateDiagramText((DiagramIntent)new SimpleDiagramIntent(result.toString()));
    }

    private void generatePackage(String packageName, Collection<IType> types, StringBuilder result) {
        result.append("package ");
        result.append(packageName);
        if (this.packageStyle != null) {
            result.append(" <<");
            result.append(this.packageStyle);
            result.append(">>");
        }
        if (this.packageColor != null) {
            result.append(" #");
            result.append(this.packageColor);
        }
        result.append(" {\n");
        this.generateTypes(types, result);
        result.append("\n}\n");
    }

    private void generateTypes(Collection<IType> types, StringBuilder result) {
        JdtDiagramIntent jdtDiagramIntent = new JdtDiagramIntent(types);
        for (IType type : types) {
            jdtDiagramIntent.generateForType(type, result, this.genFlags, types);
        }
    }

    private void addTypes(Iterable<IJavaElement> elements, Collection<IType> result) {
        for (IJavaElement javaElement : elements) {
            if (javaElement instanceof ICompilationUnit) {
                try {
                    result.addAll(Arrays.asList(((ICompilationUnit)javaElement).getTypes()));
                }
                catch (JavaModelException javaModelException) {}
                continue;
            }
            if (javaElement instanceof IPackageFragment) {
                ArrayList<IJavaElement> compilationUnits = new ArrayList<IJavaElement>();
                try {
                    compilationUnits.addAll(Arrays.asList(((IPackageFragment)javaElement).getChildren()));
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                try {
                    IJavaElement[] iJavaElementArray = ((IPackageFragmentRoot)javaElement.getParent()).getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement packageFragment = iJavaElementArray[n2];
                        if (packageFragment != javaElement && javaElement.getPath().isPrefixOf(packageFragment.getPath())) {
                            try {
                                compilationUnits.addAll(Arrays.asList(((IPackageFragment)packageFragment).getChildren()));
                            }
                            catch (JavaModelException javaModelException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addTypes(compilationUnits, result);
                continue;
            }
            if (!(javaElement instanceof IParent) || javaElement.getElementName().endsWith(".jar")) continue;
            try {
                this.addTypes(Arrays.asList(((IParent)javaElement).getChildren()), result);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateView();
    }
}

