/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.svg;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sourceforge.plantuml.eclipse.Activator;
import net.sourceforge.plantuml.eclipse.imagecontrol.ILinkSupport;
import net.sourceforge.plantuml.eclipse.svg.Svg2HtmlConverter;
import net.sourceforge.plantuml.eclipse.svg.SvgMustache2HtmlConverter;
import net.sourceforge.plantuml.eclipse.svg.SvgPreferencePage;
import net.sourceforge.plantuml.eclipse.views.AbstractDiagramSourceView;
import net.sourceforge.plantuml.eclipse.views.AbstractPlantUmlView;
import net.sourceforge.plantuml.util.DiagramData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class PlantUmlSvgView
extends AbstractPlantUmlView
implements ILinkSupport {
    private Browser browser;
    private Svg2HtmlConverter svg2HtmlConverter;
    private String diagramHtml = null;
    private final int browserStyle = 14;

    protected void createDiagramControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.setJavascriptEnabled(true);
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                PlantUmlSvgView.this.openLink(event.location);
            }

            public void changed(LocationEvent event) {
            }
        });
        this.svg2HtmlConverter = new SvgMustache2HtmlConverter();
    }

    public void dispose() {
        this.browser = null;
        super.dispose();
    }

    public void setFocus() {
        if (this.isValidControl((Control)this.browser)) {
            this.browser.setFocus();
        }
    }

    protected void updateSvg2HtmlConverter() {
        if (this.svg2HtmlConverter instanceof SvgMustache2HtmlConverter) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            String templateUrlPreference = SvgPreferencePage.getTemplateUrlPreference(preferenceStore);
            ((SvgMustache2HtmlConverter)this.svg2HtmlConverter).setTemplateUrl(templateUrlPreference);
        }
    }

    protected void updateDiagram(DiagramData diagramData, IProgressMonitor monitor) {
        String svg = diagramData.getSvg(0);
        this.updateSvg2HtmlConverter();
        this.diagramHtml = this.svg2HtmlConverter.convert2Html(svg);
        this.setDiagramViewStatus(AbstractDiagramSourceView.ViewStatus.DIAGRAM_VIEW_DATA, this.diagramHtml);
        this.asyncExec(() -> {
            if (this.isValidControl((Control)this.browser) && this.shouldUpdateView(diagramData)) {
                this.browser.setText(this.diagramHtml);
                this.setDiagramViewStatus(AbstractDiagramSourceView.ViewStatus.DIAGRAM_VIEW, this.diagramHtml);
            }
        });
    }

    public Object getLink(int x, int y) {
        return null;
    }

    protected void addViewActions(IContributionManager toolBarManager) {
        super.addViewActions(toolBarManager);
        this.addActions(toolBarManager, new IAction[]{new Action("Open in external browser", ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/external_browser.png")){

            public void run() {
                PlantUmlSvgView.this.openInBrowser(true);
            }
        }});
    }

    protected void openInBrowser(boolean external) {
        if (this.diagramHtml != null) {
            try {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                IWebBrowser extBrowser = external ? browserSupport.getExternalBrowser() : browserSupport.createBrowser(14, ((Object)((Object)this)).toString(), this.getPartName(), this.getTitle());
                Path tempFile = Files.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), ".html", new FileAttribute[0]);
                Files.write(tempFile, this.diagramHtml.getBytes(), new OpenOption[0]);
                extBrowser.openURL(tempFile.toUri().toURL());
            }
            catch (PartInitException partInitException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

