/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.svg;

import net.sourceforge.plantuml.eclipse.Activator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class SvgPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static String TEMPLATE_URL_DEFAULT = "platform:/plugin/net.sourceforge.plantuml.svg/templates/interactive-svg-template.mustache";
    public static String TEMPLATE_URL_PREFERENCE = "templateUrl";
    private Text templateUrlText;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public static String getTemplateUrlPreference(IPreferenceStore preferenceStore) {
        String templateUrlPreference = preferenceStore.getString(TEMPLATE_URL_PREFERENCE);
        return templateUrlPreference != null && templateUrlPreference.trim().length() > 0 ? templateUrlPreference.trim() : TEMPLATE_URL_DEFAULT;
    }

    protected Control createContents(final Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        Group templateUrlGroup = new Group(panel, 0);
        templateUrlGroup.setText("Svg template settings");
        templateUrlGroup.setLayout((Layout)new GridLayout(2, false));
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        String templateUrlPreference = SvgPreferencePage.getTemplateUrlPreference(preferenceStore);
        this.templateUrlText = new Text((Composite)templateUrlGroup, 0);
        this.templateUrlText.setText(templateUrlPreference);
        Button templateUrlButton = new Button((Composite)templateUrlGroup, 0);
        templateUrlButton.setText("Browse...");
        templateUrlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] selection;
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(parent.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
                dialog.setTitle("Select template");
                if (dialog.open() == 0 && (selection = dialog.getResult()).length > 0) {
                    IPath path = null;
                    if (selection[0] instanceof IFile) {
                        path = ((IResource)selection[0]).getFullPath();
                    } else if (selection[0] instanceof IPath) {
                        path = (IPath)selection[0];
                    }
                    if (path != null) {
                        SvgPreferencePage.this.templateUrlText.setText("platform:/resource" + path.toString());
                    }
                }
            }
        });
        return panel;
    }

    protected void performDefaults() {
        this.templateUrlText.setText(TEMPLATE_URL_DEFAULT);
    }

    public boolean performOk() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (this.templateUrlText != null) {
            preferenceStore.setValue(TEMPLATE_URL_PREFERENCE, this.templateUrlText.getText());
        }
        return true;
    }
}

