/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions;

import java.util.function.Supplier;
import net.sourceforge.plantuml.eclipse.imagecontrol.ImageControl;
import net.sourceforge.plantuml.eclipse.imagecontrol.jface.actions.ControlAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class ZoomAction
extends ControlAction<ImageControl> {
    private final float zoomRate;

    public ZoomAction(Supplier<ImageControl> imageControlSupplier, float zoomRate) {
        super(imageControlSupplier);
        if ((double)zoomRate == 1.0 || (double)zoomRate <= 0.0) {
            throw new IllegalArgumentException("Illegal zoom rate value: " + zoomRate);
        }
        this.setImageDescriptor(ImageDescriptor.createFromFile(ControlAction.class, (String)((double)zoomRate > 1.0 ? "/icons/ZoomIn16.gif" : "/icons/ZoomOut16.gif")));
        this.zoomRate = zoomRate;
    }

    public void run() {
        ((ImageControl)((Object)this.getControl())).zoomCentered(this.zoomRate);
    }
}

