/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters090.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters090.utils.HWTransformationCache;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.3"}, service={ICache.class, HWCacheBuilder.class})
public class HWCacheBuilder
implements ICache {
    @Reference
    SessionLogger logger;
    public static final String CACHE_KEY = "PeriodicStimulus_Containing_Clock";
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        if (this.logger != null) {
            this.logger.info("Build up HWTransformationCache for 0.8.3", new Object[0]);
        }
        HWTransformationCache cache = new HWTransformationCache();
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            Element oldHWModelElement;
            File targetFile = entry.getKey();
            Document document = entry.getValue();
            if (document == null) continue;
            Element rootElement = document.getRootElement();
            if (rootElement != null && (oldHWModelElement = rootElement.getChild("hwModel")) != null) {
                Object attributeValue;
                Element oldHWSystem = oldHWModelElement.getChild("system");
                if (oldHWSystem != null) {
                    List oldHWQuartzes = oldHWSystem.getChildren("quartzes");
                    for (Element oldHWQuartz : oldHWQuartzes) {
                        attributeValue = oldHWQuartz.getAttributeValue("name");
                        if (attributeValue == null) continue;
                        cache.getOldHwQuartzsMap().put(HelperUtil.encodeName((String)attributeValue), oldHWQuartz);
                    }
                    List oldHWECUs = oldHWSystem.getChildren("ecus");
                    for (Element oldHWECU : oldHWECUs) {
                        List oldHWMicroControllers = oldHWECU.getChildren("microcontrollers");
                        for (Element oldHWMicroController : oldHWMicroControllers) {
                            List oldHWCores = oldHWMicroController.getChildren("cores");
                            for (Element oldHWCore : oldHWCores) {
                                String attributeValue2 = oldHWCore.getAttributeValue("name");
                                if (attributeValue2 == null) continue;
                                cache.getOldCoresMap().put(HelperUtil.encodeName((String)attributeValue2), oldHWCore);
                            }
                        }
                    }
                }
                List oldHWMemoryTypes = oldHWModelElement.getChildren("memoryTypes");
                for (Element oldHWMemoryType : oldHWMemoryTypes) {
                    attributeValue = oldHWMemoryType.getAttributeValue("name");
                    if (attributeValue == null) continue;
                    cache.getOldMemoryTypesDefinitionMap().put(HelperUtil.encodeName((String)attributeValue), oldHWMemoryType);
                }
            }
            HashMap<String, HWTransformationCache> hashMap = new HashMap<String, HWTransformationCache>();
            hashMap.put("globalCache", cache);
            this.map.put(targetFile, hashMap);
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

