/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.handlers;

import javax.inject.Named;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Evaluate;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AmaltheaResourceExpression {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Evaluate
    public boolean evaluate(@Optional @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (selection == null) return false;
        if (selection.isEmpty()) return false;
        if (selection.size() > 1) return false;
        if (!(selection.getFirstElement() instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)selection.getFirstElement();
        if (this.isFileWithModelExtension(resource)) {
            return true;
        }
        if (!(resource instanceof IContainer)) return false;
        IContainer container = (IContainer)resource;
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource member = iResourceArray[n2];
                if (this.isFileWithModelExtension(member)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error("Failed to collect model files", (Throwable)e);
        }
        return false;
    }

    private boolean isFileWithModelExtension(IResource resource) {
        return resource instanceof IFile && MigrationHelper.isModelFileExtension((String)resource.getFileExtension());
    }
}

